/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.sapling;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.mod.feature.BlockDataConfig;
import com.terraforged.mod.featuremanager.template.feature.TemplateFeatureConfig;
import com.terraforged.mod.featuremanager.template.template.TemplateManager;
import com.terraforged.mod.featuremanager.util.Json;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SaplingConfig
implements BlockDataConfig {
    private final Block block;
    private final List<TemplateFeatureConfig> normal;
    private final List<TemplateFeatureConfig> giant;

    private SaplingConfig(Block block, List<TemplateFeatureConfig> normal, List<TemplateFeatureConfig> giant) {
        this.block = block;
        this.normal = normal;
        this.giant = giant;
    }

    @Override
    public Block getTarget() {
        return this.block;
    }

    public boolean hasNormal() {
        return !this.normal.isEmpty();
    }

    public boolean hasGiant() {
        return !this.giant.isEmpty();
    }

    public TemplateFeatureConfig next(Random random, boolean giant) {
        TemplateFeatureConfig config;
        if (giant && (config = this.nextGiant(random)) != null) {
            return config;
        }
        return this.nextNormal(random);
    }

    public TemplateFeatureConfig nextNormal(Random random) {
        if (this.normal.isEmpty()) {
            return null;
        }
        return this.normal.get(random.nextInt(this.normal.size()));
    }

    public TemplateFeatureConfig nextGiant(Random random) {
        if (this.giant.isEmpty()) {
            return null;
        }
        return this.giant.get(random.nextInt(this.giant.size()));
    }

    public static Optional<SaplingConfig> deserialize(JsonObject data) {
        String sapling = Json.getString("sapling", data, "");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(sapling));
        if (block == Blocks.field_150350_a) {
            return Optional.empty();
        }
        List<TemplateFeatureConfig> normal = SaplingConfig.deserializeList(data.getAsJsonObject("normal"));
        List<TemplateFeatureConfig> giant = SaplingConfig.deserializeList(data.getAsJsonObject("giant"));
        if (normal.isEmpty() && giant.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SaplingConfig(block, normal, giant));
    }

    private static List<TemplateFeatureConfig> deserializeList(JsonObject object) {
        List<TemplateFeatureConfig> list = Collections.emptyList();
        if (object != null) {
            for (Map.Entry e : object.entrySet()) {
                ResourceLocation name = new ResourceLocation((String)e.getKey());
                TemplateFeatureConfig template = TemplateManager.getInstance().getTemplateConfig(name);
                if (template == TemplateFeatureConfig.NONE) continue;
                int weight = Json.getInt("weight", ((JsonElement)e.getValue()).getAsJsonObject(), 1);
                for (int i = 0; i < weight; ++i) {
                    if (list.isEmpty()) {
                        list = new ArrayList<TemplateFeatureConfig>();
                    }
                    list.add(template);
                }
            }
        }
        return list;
    }
}

