/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.filter;

import com.terraforged.mod.api.feature.decorator.DecorationContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import net.minecraft.util.math.BlockPos;

public class PlacementFilter {
    private static final Map<String, PlacementFilter> REGISTRY = new ConcurrentHashMap<String, PlacementFilter>();
    private final String name;
    private final BiPredicate<DecorationContext, BlockPos> filter;

    public PlacementFilter(String name, BiPredicate<DecorationContext, BlockPos> filter) {
        this.name = name;
        this.filter = filter;
    }

    public String getName() {
        return this.name;
    }

    public boolean test(DecorationContext context, BlockPos pos) {
        return true;
    }

    private static void register(String name, BiPredicate<DecorationContext, BlockPos> filter) {
        REGISTRY.put(name, new PlacementFilter(name, filter));
    }

    public static Optional<PlacementFilter> decode(String name) {
        return Optional.ofNullable(REGISTRY.get(name));
    }

    static {
        PlacementFilter.register("biome", (ctx, pos) -> ctx.getBiome((BlockPos)pos) == ctx.getBiomes().getFeatureBiome());
    }
}

