/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.context.modifier;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.terraforged.mod.feature.context.ChanceContext;
import com.terraforged.mod.feature.context.modifier.ContextModifier;
import com.terraforged.mod.util.RangeModifier;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public abstract class RangeContextModifier
extends RangeModifier
implements ContextModifier {
    public RangeContextModifier(float min, float max, boolean exclusive) {
        super(min, max, exclusive);
    }

    protected abstract float getValue(BlockPos var1, ChanceContext var2);

    @Override
    public float getChance(BlockPos pos, ChanceContext context) {
        return this.apply(this.getValue(pos, context));
    }

    @Override
    public <T> Dynamic<T> serialize(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("from"), (Object)ops.createFloat(this.from), (Object)ops.createString("to"), (Object)ops.createFloat(this.to), (Object)ops.createString("exclusive"), (Object)ops.createBoolean(this.max == 0.0f))));
    }

    public static <T extends RangeContextModifier> T deserialize(Dynamic<?> dynamic, Factory<T> factory) {
        float from = dynamic.get("from").asFloat(0.0f);
        float to = dynamic.get("to").asFloat(1.0f);
        boolean exclusive = dynamic.get("exclusive").asBoolean(false);
        return factory.create(from, to, exclusive);
    }

    public static interface Factory<T extends RangeContextModifier> {
        public T create(float var1, float var2, boolean var3);
    }
}

