/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.mod.Log;
import com.terraforged.mod.data.DataGen;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;

public class WorldGenExport
extends DataGen {
    public static void export(File dataDir, MinecraftServer server, Biome[] biomes) {
        DynamicRegistries registries = server.func_244267_aX();
        WorldGenSettingsExport ops = WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)registries);
        WorldGenExport.export(dataDir, WorldGenExport.setOf(biomes), registries, (DynamicOps<JsonElement>)ops, Registry.field_239720_u_, Biome.field_242418_b);
        WorldGenExport.export(dataDir, registries, (DynamicOps<JsonElement>)ops, Registry.field_243551_at, ConfiguredCarver.field_236235_a_);
        WorldGenExport.export(dataDir, registries, (DynamicOps<JsonElement>)ops, Registry.field_243552_au, ConfiguredFeature.field_242763_a);
        WorldGenExport.export(dataDir, registries, (DynamicOps<JsonElement>)ops, Registry.field_243553_av, StructureFeature.field_236267_a_);
        WorldGenExport.export(dataDir, registries, (DynamicOps<JsonElement>)ops, Registry.field_243549_ar, DimensionSettings.field_236097_a_);
    }

    protected static <T> Set<T> setOf(T[] elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    protected static <T> void export(File dataDir, DynamicRegistries registries, DynamicOps<JsonElement> ops, RegistryKey<Registry<T>> key, Codec<T> codec) {
        WorldGenExport.export(dataDir, Collections.emptySet(), registries, ops, key, codec);
    }

    protected static <T> void export(File dataDir, Set<?> filter, DynamicRegistries registries, DynamicOps<JsonElement> ops, RegistryKey<Registry<T>> key, Codec<T> codec) {
        MutableRegistry registry = registries.func_243612_b(key);
        for (Map.Entry entry : registry.func_239659_c_()) {
            if (!filter.isEmpty() && !filter.contains(entry.getValue())) continue;
            EncodeResult result = WorldGenExport.encode(ops, (RegistryKey)entry.getKey(), entry.getValue(), codec);
            if (result.json.isJsonNull()) {
                Log.err("Failed first encode: {}. Error: {}", entry.getKey(), result.error);
                result = WorldGenExport.encode((DynamicOps<JsonElement>)JsonOps.INSTANCE, (RegistryKey)entry.getKey(), entry.getValue(), codec);
            }
            if (result.json.isJsonNull()) {
                Log.err("Failed second encode: {}. Error: {}", entry.getKey(), result.error);
                continue;
            }
            WorldGenExport.write(result.json, dataDir, WorldGenExport.getJsonPath((RegistryKey)entry.getKey()));
        }
    }

    protected static <T> EncodeResult encode(DynamicOps<JsonElement> ops, RegistryKey<T> key, T value, Codec<T> codec) {
        DataResult result = codec.encodeStart(ops, value);
        JsonElement json = (JsonElement)result.result().orElse(JsonNull.INSTANCE);
        String error = result.error().map(DataResult.PartialResult::message).orElse("unknown");
        return new EncodeResult(json, error);
    }

    protected static class EncodeResult {
        public final JsonElement json;
        public final String error;

        public EncodeResult(JsonElement json, String error) {
            this.json = json;
            this.error = error;
        }
    }
}

