/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConfigRef
implements Supplier<CommentedFileConfig> {
    private final String configVersion;
    private final StampedLock lock = new StampedLock();
    private final Function<String, CommentedFileConfig> factory;
    private CommentedFileConfig ref;

    public ConfigRef(Supplier<CommentedFileConfig> factory) {
        this("", v -> (CommentedFileConfig)factory.get());
    }

    public ConfigRef(String configVersion, Function<String, CommentedFileConfig> factory) {
        this.factory = factory;
        this.configVersion = configVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommentedFileConfig get() {
        long read = this.lock.readLock();
        try {
            if (this.ref != null) {
                this.ref.load();
                CommentedFileConfig commentedFileConfig = this.ref;
                return commentedFileConfig;
            }
        }
        finally {
            this.lock.unlockRead(read);
        }
        long write = this.lock.writeLock();
        try {
            if (this.ref != null) {
                CommentedFileConfig commentedFileConfig = this.ref;
                return commentedFileConfig;
            }
            CommentedFileConfig commentedFileConfig = this.ref = this.factory.apply(this.configVersion);
            return commentedFileConfig;
        }
        finally {
            this.lock.unlockWrite(write);
        }
    }

    public ConfigRef load() {
        this.get();
        return this;
    }

    public ConfigRef save() {
        this.get().save();
        return this;
    }

    public void set(Consumer<CommentedFileConfig> setter) {
        CommentedFileConfig config = this.get();
        setter.accept(config);
        config.save();
    }

    public int getInt(String name, int def) {
        return this.getNumber(name, def).intValue();
    }

    public long getLong(String name, long def) {
        return this.getNumber(name, def).longValue();
    }

    public float getFloat(String name, float def) {
        return this.getNumber(name, Float.valueOf(def)).floatValue();
    }

    public double getDouble(String name, double def) {
        return this.getNumber(name, def).doubleValue();
    }

    public boolean getBool(String name, boolean def) {
        return this.getValue(name, def);
    }

    public <T extends Number> Number getNumber(String name, T def) {
        return this.getValue(name, def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getValue(String name, T def) {
        long read = this.lock.tryReadLock();
        if (read != 0L) {
            try {
                CommentedFileConfig current = this.ref;
                if (current == null) {
                    T t = def;
                    return t;
                }
                Object object = current.getOrElse(name, def);
                return (T)object;
            }
            catch (Throwable t) {
                T t2 = def;
                return t2;
            }
            finally {
                this.lock.unlockRead(read);
            }
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BiConsumer<String, Object> consumer) {
        long read = this.lock.tryReadLock();
        if (read != 0L) {
            try {
                CommentedFileConfig current = this.ref;
                if (current != null) {
                    current.entrySet().forEach((? super T entry) -> consumer.accept(entry.getKey(), entry.getValue()));
                }
            }
            finally {
                this.lock.unlockRead(read);
            }
        }
    }
}

