/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.util;

import com.google.common.collect.ImmutableSet;
import com.terraforged.mod.api.chunk.ChunkDelegate;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;

public class FastChunk
extends ChunkDelegate {
    private static final Set<Heightmap.Type> HEIGHT_MAPS = ImmutableSet.of((Object)Heightmap.Type.OCEAN_FLOOR_WG, (Object)Heightmap.Type.WORLD_SURFACE_WG);
    private final int blockX;
    private final int blockZ;
    private final ChunkPrimer primer;
    private final Heightmap worldSurface;
    private final Heightmap oceanSurface;
    private final BlockPos.Mutable mutable = new BlockPos.Mutable();

    protected FastChunk(ChunkPrimer primer) {
        super((IChunk)primer);
        this.primer = primer;
        this.blockX = primer.func_76632_l().func_180334_c();
        this.blockZ = primer.func_76632_l().func_180333_d();
        this.worldSurface = primer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        this.oceanSurface = primer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
    }

    @Override
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean falling) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            ChunkSection section = this.primer.func_217332_a(pos.func_177956_o() >> 4);
            section.func_222635_a();
            int dx = pos.func_177958_n() & 0xF;
            int dy = pos.func_177956_o() & 0xF;
            int dz = pos.func_177952_p() & 0xF;
            BlockState replaced = section.func_177484_a(dx, dy, dz, state, false);
            if (!state.func_196958_f()) {
                this.mutable.func_181079_c(this.blockX + dx, pos.func_177956_o(), this.blockZ + dz);
                if (state.getLightValue((IBlockReader)this.primer, (BlockPos)this.mutable) != 0) {
                    this.primer.func_201637_h((BlockPos)this.mutable);
                }
                this.worldSurface.func_202270_a(dx, pos.func_177956_o(), dz, state);
                this.oceanSurface.func_202270_a(dx, pos.func_177956_o(), dz, state);
            }
            section.func_222637_b();
            return replaced;
        }
        return Blocks.field_201940_ji.func_176223_P();
    }

    public void setBiomes(BiomeContainer biomes) {
        this.primer.func_225548_a_(biomes);
    }

    public static IChunk wrap(IChunk chunk) {
        if (chunk instanceof FastChunk) {
            return chunk;
        }
        if (chunk.getClass() == ChunkPrimer.class) {
            return new FastChunk((ChunkPrimer)chunk);
        }
        return chunk;
    }

    public static void updateWGHeightmaps(IChunk chunk) {
        Heightmap.func_222690_a((IChunk)chunk, HEIGHT_MAPS);
    }
}

