/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.engine.tile.api.TileProvider;
import com.terraforged.mod.api.biome.surface.SurfaceManager;
import com.terraforged.mod.api.chunk.column.ColumnDecorator;
import com.terraforged.mod.chunk.SetupFactory;
import com.terraforged.mod.chunk.TFChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.featuremanager.FeatureManager;
import com.terraforged.mod.featuremanager.data.DataManager;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.util.setup.SetupHooks;
import java.util.List;
import java.util.function.Function;

public class GeneratorResources {
    public static final int SEED_OFFSET = 746382634;
    final TileProvider tileCache;
    final FeatureManager featureManager;
    final BlockDataManager blockDataManager;
    final GeoManager geologyManager;
    final SurfaceManager surfaceManager;
    final List<ColumnDecorator> surfaceDecorators;
    final List<ColumnDecorator> postProcessors;

    public GeneratorResources(TFChunkGenerator generator, TerraContext context) {
        this.surfaceManager = SetupFactory.createSurfaceManager(context);
        this.geologyManager = SetupFactory.createGeologyManager(context);
        this.surfaceDecorators = SetupFactory.createSurfaceDecorators(context);
        this.postProcessors = SetupFactory.createFeatureDecorators(context);
        try (DataManager data = SetupFactory.createDataManager();){
            FeatureManager.initData(data);
            this.featureManager = SetupFactory.createFeatureManager(data, context, generator);
            this.blockDataManager = SetupFactory.createBlockDataManager(data, context);
            FeatureManager.clearData();
        }
        SetupHooks.setup(((Materials)context.materials.get()).layerManager, context);
        SetupHooks.setup(this.surfaceDecorators, this.postProcessors, context);
        this.tileCache = (TileProvider)context.cache.get();
    }

    public static Function<TerraContext, GeneratorResources> factory(TFChunkGenerator generator) {
        return context -> new GeneratorResources(generator, (TerraContext)context);
    }
}

