/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider.analyser;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.terraforged.engine.world.biome.map.BiomeMap;
import com.terraforged.engine.world.biome.map.BiomeMapBuilder;
import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.context.TFBiomeContext;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.biome.provider.BiomeWeights;
import com.terraforged.mod.biome.provider.analyser.BiomeFilter;
import com.terraforged.mod.biome.provider.analyser.BiomePredicate;
import com.terraforged.mod.biome.provider.analyser.TFBiomeCollector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class BiomeAnalyser {
    private static final Map<BiomeType, BiomePredicate> PREDICATES = new HashMap<BiomeType, BiomePredicate>(){
        {
            this.put(BiomeType.TROPICAL_RAINFOREST, BiomePredicate.TROPICAL_RAINFOREST);
            this.put(BiomeType.SAVANNA, BiomePredicate.SAVANNA.or(BiomePredicate.MESA).not(BiomePredicate.DESERT).not(BiomePredicate.STEPPE).not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.DESERT, BiomePredicate.DESERT.or(BiomePredicate.MESA).not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.TEMPERATE_RAINFOREST, BiomePredicate.TEMPERATE_RAINFOREST.not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.TEMPERATE_FOREST, BiomePredicate.TEMPERATE_FOREST.not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.WETLAND));
            this.put(BiomeType.GRASSLAND, BiomePredicate.GRASSLAND.not(BiomePredicate.WETLAND).not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.COLD_STEPPE, BiomePredicate.COLD_STEPPE.not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.STEPPE, BiomePredicate.STEPPE.not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN).not(BiomePredicate.COLD_STEPPE));
            this.put(BiomeType.TAIGA, BiomePredicate.TAIGA.not(BiomePredicate.TUNDRA).not(BiomePredicate.COLD_STEPPE).not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.TUNDRA, BiomePredicate.TUNDRA.not(BiomePredicate.TAIGA).not(BiomePredicate.BEACH).not(BiomePredicate.MOUNTAIN));
            this.put(BiomeType.ALPINE, BiomePredicate.MOUNTAIN);
        }
    };
    private static final BiomeFilter[] EXCLUSION_FILTERS = new BiomeFilter[]{(biome, context) -> biome.func_201856_r() == Biome.Category.THEEND, (biome, context) -> biome.func_201856_r() == Biome.Category.NETHER, (biome, context) -> context.biomes.getName(biome).contains("hills"), (biome, context) -> biome == context.biomes.get((RegistryKey<Biome>)Biomes.field_185440_P), (biome, context) -> biome == context.biomes.get((RegistryKey<Biome>)Biomes.field_76783_v), (biome, context) -> !BiomeHelper.isOverworldBiome(biome, context)};

    public static BiomeMap<RegistryKey<Biome>> createBiomeMap(TFBiomeContext context) {
        BiomeMap.Builder<RegistryKey<Biome>> builder = BiomeMapBuilder.create(context);
        BiomeWeights weights = new BiomeWeights(context);
        BiomeAnalyser.collectOverworldBiomes(context, weights, builder);
        builder.addLand(BiomeType.TEMPERATE_RAINFOREST, (RegistryKey<Biome>)Biomes.field_76772_c, 5);
        builder.addLand(BiomeType.TEMPERATE_FOREST, (RegistryKey<Biome>)Biomes.field_185444_T, 2);
        builder.addLand(BiomeType.TEMPERATE_FOREST, (RegistryKey<Biome>)Biomes.field_76772_c, 5);
        builder.addLand(BiomeType.TUNDRA, ModBiomes.SNOWY_TAIGA_SCRUB, 2);
        builder.addLand(BiomeType.TAIGA, ModBiomes.TAIGA_SCRUB, 2);
        return builder.build();
    }

    public static Biome[] getOverworldBiomes(TFBiomeContext context) {
        TFBiomeCollector collector = new TFBiomeCollector(context);
        BiomeAnalyser.collectOverworldBiomes(context, i -> 0, collector);
        return collector.getBiomes();
    }

    public static List<Biome> getOverworldBiomesList(TFBiomeContext context) {
        return BiomeAnalyser.getOverworldBiomesList(context, Function.identity());
    }

    public static <T> List<T> getOverworldBiomesList(TFBiomeContext context, Function<Biome, T> mapper) {
        return BiomeAnalyser.getOverworldBiomes(context, mapper, ImmutableList.builder()).build();
    }

    public static Set<Biome> getOverworldBiomesSet(TFBiomeContext context) {
        return BiomeAnalyser.getOverworldBiomesSet(context, Function.identity());
    }

    public static <T> Set<T> getOverworldBiomesSet(TFBiomeContext context, Function<Biome, T> mapper) {
        return BiomeAnalyser.getOverworldBiomes(context, mapper, ImmutableSet.builder()).build();
    }

    public static <T, C extends ImmutableCollection.Builder<T>> C getOverworldBiomes(TFBiomeContext context, Function<Biome, T> mapper, C builder) {
        Biome[] biomes;
        for (Biome biome : biomes = BiomeAnalyser.getOverworldBiomes(context)) {
            T t = mapper.apply(biome);
            builder.add(t);
        }
        return builder;
    }

    private static void collectOverworldBiomes(TFBiomeContext context, IntUnaryOperator weightFunc, BiomeMap.Builder<RegistryKey<Biome>> builder) {
        for (Biome biome : context.biomes) {
            if (BiomeAnalyser.filter(biome, context)) continue;
            int id = context.biomes.getId(biome);
            RegistryKey<Biome> key = context.biomes.getKey(biome);
            int weight = weightFunc.applyAsInt(id);
            if (BiomePredicate.BEACH.test(id, context)) {
                builder.addBeach(key, weight);
                continue;
            }
            if (BiomePredicate.COAST.test(id, context)) {
                builder.addCoast(key, weight);
                continue;
            }
            if (BiomePredicate.OCEAN.test(id, context)) {
                builder.addOcean(key, weight);
                continue;
            }
            if (BiomePredicate.RIVER.test(id, context)) {
                builder.addRiver(key, weight);
                continue;
            }
            if (BiomePredicate.LAKE.test(id, context)) {
                builder.addLake(key, weight);
                continue;
            }
            if (BiomePredicate.WETLAND.test(id, context)) {
                builder.addWetland(key, weight);
                continue;
            }
            if (BiomePredicate.VOLCANO.test(id, context)) {
                builder.addVolcano(key, weight);
                continue;
            }
            if (BiomePredicate.MOUNTAIN.test(id, context)) {
                builder.addMountain(key, weight);
                continue;
            }
            Collection<BiomeType> types = BiomeAnalyser.getTypes(id, context);
            for (BiomeType type : types) {
                if (type == BiomeType.ALPINE) continue;
                builder.addLand(type, key, weight);
            }
        }
    }

    public static Collection<BiomeType> getTypes(int biome, TFBiomeContext context) {
        HashSet<BiomeType> types = new HashSet<BiomeType>();
        for (Map.Entry<BiomeType, BiomePredicate> entry : PREDICATES.entrySet()) {
            if (!entry.getValue().test(biome, context)) continue;
            types.add(entry.getKey());
        }
        return types;
    }

    private static boolean filter(Biome biome, TFBiomeContext context) {
        for (BiomeFilter filter : EXCLUSION_FILTERS) {
            if (!filter.test(biome, context)) continue;
            return true;
        }
        return false;
    }
}

