/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.flightevents;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.misc.CrashTypes;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.tileentities.ConsoleTile;

public class TimeStorm
extends FlightEvent {
    public static final Supplier<ArrayList<ResourceLocation>> CONTROLS = () -> Lists.newArrayList((Object[])new ResourceLocation[]{((ControlRegistry.ControlEntry)ControlRegistry.RANDOM.get()).getRegistryName(), ((ControlRegistry.ControlEntry)ControlRegistry.INC_MOD.get()).getRegistryName(), ((ControlRegistry.ControlEntry)ControlRegistry.THROTTLE.get()).getRegistryName()});

    public TimeStorm(FlightEventFactory entry, ArrayList<ResourceLocation> loc) {
        super(entry, loc);
    }

    public boolean onComplete(ConsoleTile tile) {
        boolean complete = super.onComplete(tile);
        if (complete) {
            tile.setDestinationReachedTick(100);
            tile.updateClient();
        }
        return complete;
    }

    public void onMiss(ConsoleTile tile) {
        super.onMiss(tile);
        tile.damage(150.0f);
        tile.crash(CrashTypes.DEFAULT);
        tile.updateClient();
    }

    public int calcTime(ConsoleTile console) {
        ObjectWrapper wrapper = new ObjectWrapper((Object)Float.valueOf(0.0f));
        console.getControl(ThrottleControl.class).ifPresent(throt -> wrapper.setValue((Object)Float.valueOf(throt.getAmount())));
        float amt = ((Float)wrapper.getValue()).floatValue();
        int seconds = (Integer)TConfig.SERVER.controlTime.get() * 60;
        this.timeUntilMiss = console.flightTicks + seconds + (int)Math.floor((1.0f - amt) * (float)seconds);
        return this.timeUntilMiss;
    }
}

