/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.flightevents;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.tadditions.mod.config.MConfigs;
import net.tadditions.mod.flightevents.AlternatingWinds;
import net.tadditions.mod.flightevents.Basins;
import net.tadditions.mod.flightevents.DriveCore;
import net.tadditions.mod.flightevents.HullBreach;
import net.tadditions.mod.flightevents.ImpendCollision;
import net.tadditions.mod.flightevents.TimeStorm;
import net.tadditions.mod.flightevents.Vector;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.registries.FlightEventRegistry;

public class MFlightEvent
extends FlightEventRegistry {
    public static final DeferredRegister<FlightEventFactory> FLIGHT_EVENTS = DeferredRegister.create(FlightEventFactory.class, (String)"tadditions");
    public static final RegistryObject<FlightEventFactory> ALTIMEWIND = FLIGHT_EVENTS.register("alternating_time_wind", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)AlternatingWinds::new), AlternatingWinds.CONTROLS));
    public static final RegistryObject<FlightEventFactory> TIMESTORM = FLIGHT_EVENTS.register("time_storm", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)TimeStorm::new), TimeStorm.CONTROLS));
    public static final RegistryObject<FlightEventFactory> VECTOR = FLIGHT_EVENTS.register("vector", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)Vector::new), Vector.CONTROLS));
    public static final RegistryObject<FlightEventFactory> DRIVECORE = FLIGHT_EVENTS.register("drive", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)DriveCore::new), DriveCore.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> BASINS = FLIGHT_EVENTS.register("basins", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)Basins::new), Basins.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> HULLBREACH = FLIGHT_EVENTS.register("hullbreach", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)HullBreach::new), HullBreach.CONTROLS, false));
    public static final RegistryObject<FlightEventFactory> COLLISION = FLIGHT_EVENTS.register("collision", () -> MFlightEvent.setupFlightEvent((FlightEventFactory.IFlightEventFactory<FlightEvent>)((FlightEventFactory.IFlightEventFactory)ImpendCollision::new), ImpendCollision.CONTROLS, false));

    public static FlightEventFactory setupFlightEvent(FlightEventFactory.IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence) {
        FlightEventFactory fact = new FlightEventFactory(event, sequence);
        return fact;
    }

    public static FlightEventFactory setupFlightEvent(FlightEventFactory.IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence, boolean normal) {
        FlightEventFactory fact = MFlightEvent.setupFlightEvent(event, sequence);
        fact.setNormal(false);
        return fact;
    }

    public static void addRandomEvent(int weight, FlightEventFactory event) {
        FlightEventRegistry.RANDOM_EVENTS.addChance(weight, (Object)event);
    }

    public static void registerRandomEntries() {
        MFlightEvent.addRandomEvent((Integer)MConfigs.COMMON.AlternatingWindRarity.get(), (FlightEventFactory)ALTIMEWIND.get());
        MFlightEvent.addRandomEvent((Integer)MConfigs.COMMON.VectorErrorRarity.get(), (FlightEventFactory)VECTOR.get());
        MFlightEvent.addRandomEvent((Integer)MConfigs.COMMON.StormRarity.get(), (FlightEventFactory)TIMESTORM.get());
    }
}

