/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mod.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tadditions.mod.cap.IOneRemote;
import net.tadditions.mod.cap.IOpener;
import net.tadditions.mod.cap.OneUseRemoteCapability;
import net.tadditions.mod.cap.TagreaOpenerCap;
import net.tadditions.mod.items.ModItems;
import net.tadditions.mod.world.MDimensions;
import net.tardis.mod.cap.ISpaceDimProperties;
import net.tardis.mod.cap.SpaceDimensionCapability;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.events.MissingMappingsLookup;

@Mod.EventBusSubscriber(modid="tadditions", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    public static final ResourceLocation ONEUSEREMOTE_CAP = new ResourceLocation("tadditions", "oneuseremote");
    public static final ResourceLocation TAGREAOPENER_CAP = new ResourceLocation("tadditions", "tagreaopener");
    private static HashMap<ResourceLocation, ResourceLocation> remappedEntries = new HashMap();

    @SubscribeEvent
    public static void attachWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (((World)event.getObject()).func_234923_W_() == MDimensions.MARS) {
            event.addCapability(net.tardis.mod.events.CommonEvents.SPACE_DIM_CAP, (ICapabilityProvider)new ISpaceDimProperties.Provider((ISpaceDimProperties)new SpaceDimensionCapability(((World)event.getObject()).func_234923_W_())));
        }
    }

    @SubscribeEvent
    public static void attachItemStackCap(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == ModItems.ONEUSEREMOTE.get()) {
            event.addCapability(ONEUSEREMOTE_CAP, (ICapabilityProvider)new IOneRemote.Provider(new OneUseRemoteCapability((ItemStack)event.getObject())));
        }
        if (((ItemStack)event.getObject()).func_77973_b() == ModItems.BOOS_UPGRADE.get()) {
            event.addCapability(TAGREAOPENER_CAP, (ICapabilityProvider)new IOpener.Provider(new TagreaOpenerCap((ItemStack)event.getObject())));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.func_201670_d() && ((Boolean)TConfig.CLIENT.enableBoti.get()).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.boti_warning").func_240700_a_(style -> style.func_240712_a_(TextFormatting.DARK_RED)), false);
        }
    }

    public static void getAllMappingEntries() {
        JsonObject obj = MissingMappingsLookup.getMissingMappings();
        for (Map.Entry entry : obj.entrySet()) {
            remappedEntries.put(new ResourceLocation("tadditions", (String)entry.getKey()), new ResourceLocation("tadditions", ((JsonElement)entry.getValue()).getAsString()));
        }
    }
}

