/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraftforge.registries.IForgeRegistry;
import net.tardis.mod.registries.TraitRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.traits.TardisTraitType;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={EmotionHandler.class})
public class EHMixin {
    private boolean hasGeneratedTraits = false;
    private TardisTrait[] traits = new TardisTrait[6];

    private void generateTardisTraits() {
        this.traits = new TardisTrait[5];
        int i = 0;
        ArrayList possibleTraits = Lists.newArrayList((Iterable)((IForgeRegistry)TraitRegistry.TRAIT_REGISTRY.get()).getValues());
        for (int x = 0; x < 25 && !possibleTraits.isEmpty() && x < 4; ++x) {
            TardisTraitType type = (TardisTraitType)possibleTraits.get(ConsoleTile.rand.nextInt(possibleTraits.size()));
            if (this.hasIncompatibleTrait(type)) continue;
            this.traits[i] = type.create().setWeight(ConsoleTile.rand.nextDouble());
            possibleTraits.remove(type);
            ++i;
        }
        this.hasGeneratedTraits = true;
    }

    private boolean hasIncompatibleTrait(TardisTraitType type) {
        for (int y = 0; y < this.traits.length; ++y) {
            TardisTrait old = this.traits[y];
            if (old == null || old.getType().isCompatible(type)) continue;
            return true;
        }
        return false;
    }
}

