/*
 * Decompiled with CFR 0.152.
 */
package net.tadditions.mixin;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import net.tadditions.mod.helper.IConsoleHelp;
import net.tadditions.mod.world.MDimensions;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.flight.TardisCollideInstigate;
import net.tardis.mod.flight.TardisCollideRecieve;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.CrashType;
import net.tardis.mod.misc.CrashTypes;
import net.tardis.mod.misc.ITickable;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.ConsoleUpdateMessage;
import net.tardis.mod.network.packets.console.ConsoleData;
import net.tardis.mod.network.packets.console.DataTypes;
import net.tardis.mod.network.packets.console.Fuel;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.registries.FlightEventRegistry;
import net.tardis.mod.registries.SoundSchemeRegistry;
import net.tardis.mod.registries.SubsystemRegistry;
import net.tardis.mod.registries.UpgradeRegistry;
import net.tardis.mod.sounds.AbstractSoundScheme;
import net.tardis.mod.subsystem.FlightSubsystem;
import net.tardis.mod.subsystem.StabilizerSubsystem;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.subsystem.SubsystemEntry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.ArtronUse;
import net.tardis.mod.tileentities.console.misc.ControlOverride;
import net.tardis.mod.tileentities.console.misc.DistressSignal;
import net.tardis.mod.tileentities.console.misc.EmotionHandler;
import net.tardis.mod.tileentities.console.misc.ExteriorPropertyManager;
import net.tardis.mod.tileentities.console.misc.InteriorManager;
import net.tardis.mod.tileentities.console.misc.MonitorOverride;
import net.tardis.mod.tileentities.console.misc.SparkingLevel;
import net.tardis.mod.tileentities.console.misc.UnlockManager;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.upgrades.Upgrade;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ConsoleTile.class})
public class ConsoleMixin
extends TileEntity
implements IConsoleHelp {
    public int flightTicks = 0;
    private int reachDestinationTick = 0;
    private EmotionHandler emotionHandler;
    private InteriorManager interiorManager;
    private List<PlayerEntity> players = new ArrayList<PlayerEntity>();
    private List<ITickable> tickers = new ArrayList<ITickable>();
    private HashMap<ResourceLocation, INBTSerializable<CompoundNBT>> dataHandlers = new HashMap();
    private ArrayList<ControlEntity> controls = new ArrayList();
    private ArrayList<ControlRegistry.ControlEntry> controlEntries = new ArrayList();
    private AbstractExterior exterior;
    private AbstractSoundScheme scheme;
    private BlockPos location = BlockPos.field_177992_a;
    private BlockPos destination = BlockPos.field_177992_a;
    private RegistryKey<World> dimension;
    private RegistryKey<World> destinationDimension;
    private Direction facing = Direction.NORTH;
    private float max_artron = 0.0f;
    private float artron = 0.0f;
    private float rechargeMod = 1.0f;
    private ConsoleRoom consoleRoom = ConsoleRoom.STEAM;
    private List<Subsystem> subsystems = new ArrayList<Subsystem>();
    private List<Upgrade> upgrades = new ArrayList<Upgrade>();
    private String customName = "";
    private ExteriorPropertyManager exteriorProps;
    private SpaceTimeCoord returnLocation = SpaceTimeCoord.UNIVERAL_CENTER;
    private FlightEvent currentEvent = null;
    private List<DistressSignal> distressSignal = new ArrayList<DistressSignal>();
    private ItemStack sonic = ItemStack.field_190927_a;
    protected TexVariant[] variants = new TexVariant[0];
    private int variant = 0;
    private boolean antiGravs = false;
    private boolean intGravs = false;
    private UUID tardisEntityID = null;
    private TardisEntity tardisEntity = null;
    private SparkingLevel sparkLevel = SparkingLevel.NONE;
    private String landingCode = "";
    private int landTime = 0;
    private HashMap<ArtronUse.IArtronType, ArtronUse> artronUses = Maps.newHashMap();
    private LazyOptional<ExteriorTile> exteriorHolder = LazyOptional.empty();
    private boolean dimData = false;
    private UnlockManager unlockManager;
    protected HashMap<Class<?>, ControlOverride> controlOverrides = Maps.newHashMap();
    private boolean hasPoweredDown = false;
    private boolean hasNavCom = false;
    private boolean isBeingTowed = false;
    private BlockPos takeoffLocation = BlockPos.field_177992_a;
    private boolean hasForcedChunksToRemove = false;
    private boolean shouldStartChangingInterior = false;
    private ConsoleRoom nextRoomToChange = ConsoleRoom.STEAM;
    private int timeUntilControlSpawn = 10;
    private PlayerEntity pilot;
    private Runnable onLoadAction;

    public ConsoleMixin(TileEntityType<?> type) {
        super(type);
        this.emotionHandler = new EmotionHandler((ConsoleTile)this);
        this.interiorManager = new InteriorManager((ConsoleTile)this);
        this.exteriorProps = new ExteriorPropertyManager((ConsoleTile)this);
        this.exterior = (AbstractExterior)ExteriorRegistry.STEAMPUNK.get();
        this.dimension = World.field_234918_g_;
        this.destinationDimension = World.field_234918_g_;
        this.unlockManager = new UnlockManager((ConsoleTile)this);
        this.scheme = (AbstractSoundScheme)SoundSchemeRegistry.BASIC.get();
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.HANDBRAKE.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.THROTTLE.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.RANDOM.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.DIMENSION.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.FACING.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.X.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.Y.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.Z.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.INC_MOD.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.LAND_TYPE.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.REFUELER.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.FAST_RETURN.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.TELEPATHIC.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.STABILIZERS.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.SONIC_PORT.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.COMMUNICATOR.get());
        ((ConsoleTile)this).registerControlEntry((ControlRegistry.ControlEntry)ControlRegistry.DOOR.get());
        for (SubsystemEntry entry : ((IForgeRegistry)SubsystemRegistry.SUBSYSTEM_REGISTRY.get()).getValues()) {
            this.subsystems.add(entry.create((ConsoleTile)this));
        }
        for (SubsystemEntry entry : ((IForgeRegistry)UpgradeRegistry.UPGRADE_REGISTRY.get()).getValues()) {
            this.upgrades.add(entry.create((ConsoleTile)this));
        }
        ((ConsoleTile)this).registerControlOverrides();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ConsoleRoom consoleRoom;
        ConsoleRoom consoleRoom2;
        super.func_230337_a_(state, compound);
        for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> entry : this.dataHandlers.entrySet()) {
            entry.getValue().deserializeNBT((INBT)compound.func_74775_l(entry.getKey().toString()));
        }
        ListNBT subsystemList = compound.func_150295_c("subsystems", 10);
        for (Object base : subsystemList) {
            CompoundNBT nbt = (CompoundNBT)base;
            ResourceLocation key = new ResourceLocation(nbt.func_74779_i("name"));
            ((ConsoleTile)this).getSubsystem(key).ifPresent(sys -> sys.deserializeNBT(nbt));
        }
        if (compound.func_74764_b("unlock_manager")) {
            this.unlockManager.deserializeNBT(compound.func_74775_l("unlock_manager"));
        }
        this.location = BlockPos.func_218283_e((long)compound.func_74763_f("location"));
        this.destination = BlockPos.func_218283_e((long)compound.func_74763_f("destination"));
        this.dimension = WorldHelper.getWorldKeyFromRL((ResourceLocation)new ResourceLocation(compound.func_74779_i("dimension")));
        this.destinationDimension = WorldHelper.getWorldKeyFromRL((ResourceLocation)new ResourceLocation(compound.func_74779_i("dest_dim")));
        this.flightTicks = compound.func_74762_e("flight_ticks");
        this.reachDestinationTick = compound.func_74762_e("max_flight_ticks");
        this.exterior = ExteriorRegistry.getExterior((ResourceLocation)new ResourceLocation(compound.func_74779_i("exterior")));
        this.artron = compound.func_74760_g("artron");
        if (compound.func_74764_b("console_room") && (consoleRoom2 = (ConsoleRoom)ConsoleRoom.getRegistry().get(new ResourceLocation(compound.func_74779_i("console_room")))) != null) {
            this.consoleRoom = consoleRoom2;
        }
        if (compound.func_74764_b("next_console_room") && (consoleRoom = (ConsoleRoom)ConsoleRoom.getRegistry().get(new ResourceLocation(compound.func_74779_i("next_console_room")))) != null) {
            this.nextRoomToChange = consoleRoom;
        }
        this.customName = compound.func_74779_i("custom_name");
        this.returnLocation = SpaceTimeCoord.deserialize((CompoundNBT)compound.func_74775_l("return_pos"));
        this.facing = Direction.values()[compound.func_74762_e("facing")];
        this.sonic = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("sonic_item"));
        ListNBT listNBT = compound.func_150295_c("distress_list_initial", 10);
        this.distressSignal.clear();
        for (INBT dis : listNBT) {
            this.distressSignal.add(DistressSignal.deserializeNBT((CompoundNBT)((CompoundNBT)dis)));
        }
        this.max_artron = compound.func_74760_g("max_artron");
        this.rechargeMod = compound.func_74760_g("recharge_modifier");
        this.variant = compound.func_74762_e("texture_variant");
        this.antiGravs = compound.func_74767_n("anti_gravs");
        this.antiGravs = compound.func_74767_n("int_gravs");
        this.hasForcedChunksToRemove = compound.func_74767_n("has_forced_chunks");
        this.hasNavCom = compound.func_74767_n("nav_com");
        this.dimData = compound.func_74767_n("dimdata");
        this.shouldStartChangingInterior = compound.func_74767_n("start_changing_interior");
        ListNBT artronUsesList = compound.func_150295_c("artron_uses", 10);
        for (INBT base : artronUsesList) {
            CompoundNBT nbt = (CompoundNBT)base;
            ArtronUse use = ArtronUse.deserialiseNBT((CompoundNBT)nbt);
            ArtronUse.IArtronType type = use.getType();
            if (type == null) continue;
            this.artronUses.put(type, use);
        }
        if (compound.func_74764_b("tardis_entity_id")) {
            this.tardisEntityID = compound.func_186857_a("tardis_entity_id");
        }
        this.sparkLevel = SparkingLevel.getFromIndex((int)compound.func_74762_e("spark_level"));
        this.landingCode = compound.func_74779_i("landing_code");
        this.landTime = compound.func_74762_e("landing_time");
        this.takeoffLocation = BlockPos.func_218283_e((long)compound.func_74763_f("takeoff_location"));
        if (compound.func_74764_b("sound_scheme")) {
            this.scheme = (AbstractSoundScheme)((IForgeRegistry)SoundSchemeRegistry.SOUND_SCHEME_REGISTRY.get()).getValue(new ResourceLocation(compound.func_74779_i("sound_scheme")));
        }
        this.onLoadAction = () -> {
            for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> saved : this.dataHandlers.entrySet()) {
                saved.getValue().deserializeNBT((INBT)compound.func_74775_l(saved.getKey().toString()));
            }
        };
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        for (Map.Entry<ResourceLocation, INBTSerializable<CompoundNBT>> entry : this.dataHandlers.entrySet()) {
            compound.func_218657_a(entry.getKey().toString(), entry.getValue().serializeNBT());
        }
        ListNBT subsystemList = new ListNBT();
        for (Subsystem subsystem : this.subsystems) {
            CompoundNBT nbt = subsystem.serializeNBT();
            nbt.func_74778_a("name", subsystem.getEntry().getRegistryName().toString());
            subsystemList.add((Object)nbt);
        }
        compound.func_218657_a("subsystems", (INBT)subsystemList);
        compound.func_218657_a("unlock_manager", (INBT)this.unlockManager.serializeNBT());
        compound.func_74772_a("location", this.location.func_218275_a());
        compound.func_74772_a("destination", this.destination.func_218275_a());
        compound.func_74768_a("flight_ticks", this.flightTicks);
        compound.func_74768_a("max_flight_ticks", this.reachDestinationTick);
        compound.func_74778_a("exterior", this.exterior.getRegistryName().toString());
        compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        compound.func_74778_a("dest_dim", this.destinationDimension.func_240901_a_().toString());
        compound.func_74776_a("artron", this.artron);
        compound.func_74778_a("console_room", this.consoleRoom.getRegistryName().toString());
        compound.func_74778_a("next_console_room", this.nextRoomToChange.getRegistryName().toString());
        compound.func_74778_a("custom_name", this.customName);
        compound.func_218657_a("return_pos", (INBT)this.returnLocation.serialize());
        compound.func_74768_a("facing", this.facing.ordinal());
        compound.func_74772_a("takeoff_location", this.takeoffLocation.func_218275_a());
        compound.func_218657_a("sonic_item", (INBT)this.sonic.serializeNBT());
        ListNBT listNBT = new ListNBT();
        for (DistressSignal dis : this.distressSignal) {
            listNBT.add((Object)dis.serializeNBT());
        }
        compound.func_218657_a("distress_list_initial", (INBT)listNBT);
        compound.func_74776_a("max_artron", this.max_artron);
        compound.func_74776_a("recharge_modifier", this.rechargeMod);
        compound.func_74768_a("texture_variant", this.variant);
        compound.func_74757_a("anti_gravs", this.antiGravs);
        compound.func_74757_a("int_gravs", this.intGravs);
        if (this.tardisEntityID != null) {
            compound.func_186854_a("tardis_entity_id", this.tardisEntityID);
        }
        compound.func_74768_a("spark_level", this.sparkLevel.ordinal());
        compound.func_74778_a("landing_code", this.landingCode);
        compound.func_74768_a("landing_time", this.landTime);
        compound.func_74778_a("sound_scheme", this.scheme.getRegistryName().toString());
        compound.func_74757_a("nav_com", this.hasNavCom);
        compound.func_74757_a("dimdata", this.dimData);
        compound.func_74757_a("has_forced_chunks", this.hasForcedChunksToRemove);
        compound.func_74757_a("start_changing_interior", this.shouldStartChangingInterior);
        ListNBT listNBT2 = new ListNBT();
        for (Map.Entry<ArtronUse.IArtronType, ArtronUse> entry : this.artronUses.entrySet()) {
            CompoundNBT nbt = entry.getValue().serialiseNBT();
            listNBT2.add((Object)nbt);
        }
        compound.func_218657_a("artron_uses", (INBT)listNBT2);
        return super.func_189515_b(compound);
    }

    @Override
    public boolean isDimOver() {
        return this.dimData;
    }

    @Override
    public void setDimOver(boolean DimOver) {
        this.dimData = DimOver;
        this.func_70296_d();
    }

    public void fly() {
        if (((ConsoleTile)this).isInFlight()) {
            if (this.isDimOver() && ((ConsoleTile)this).getDestinationDimension() == MDimensions.TAGREA && ((ConsoleTile)this).getPercentageJourney() == 0.9 && ((ConsoleTile)this).getCurrentDimension() != MDimensions.TAGREA) {
                ((ConsoleTile)this).crash(new CrashType(100, 0.0f, true));
                ((ConsoleTile)this).getInteriorManager().setAlarmOn(false);
                ((ConsoleTile)this).getSubSystems().forEach(sub -> sub.damage(null, 38));
                ((ConsoleTile)this).getSubsystem(FlightSubsystem.class).ifPresent(fly -> fly.damage(null, 650));
                ((ConsoleTile)this).getInteriorManager().setMonitorOverrides(new MonitorOverride((ConsoleTile)this, 600, new String[]{String.valueOf(new TranslationTextComponent("warning.spatial_rupture").getString())}));
                ((ConsoleTile)this).onPowerDown(true);
                ((ConsoleTile)this).getInteriorManager().setAlarmOn(true);
            }
            ((ConsoleTile)this).prevFlightTicks = this.flightTicks++;
            if (((ConsoleTile)this).isLanding()) {
                this.location = ((ConsoleTile)this).getPositionInFlight().getPos();
            }
            if (((ConsoleTile)this).isCrashing()) {
                ((ConsoleTile)this).playCrashEffects();
            }
            if (!this.field_145850_b.field_72995_K && this.flightTicks >= this.reachDestinationTick && this.landTime <= 0) {
                if (this.isBeingTowed) {
                    ((ConsoleTile)this).initLand();
                }
                ((ConsoleTile)this).getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
                    if (sys.isControlActivated() && !this.isBeingTowed) {
                        ((ConsoleTile)this).initLand();
                    }
                });
            }
            if (!this.field_145850_b.field_72995_K && this.flightTicks > this.landTime && this.landTime > 0) {
                this.landTime = 0;
                this.reachDestinationTick = 0;
                this.flightTicks = 0;
                ((ConsoleTile)this).updateClient();
            }
            if (!this.field_145850_b.field_72995_K && !((ConsoleTile)this).canFly()) {
                ((ConsoleTile)this).crash(CrashTypes.DEFAULT);
                return;
            }
            if (!this.field_145850_b.field_72995_K) {
                ArtronUse use = ((ConsoleTile)this).getOrCreateArtronUse((ArtronUse.IArtronType)ArtronUse.ArtronType.FLIGHT);
                use.setArtronUsePerTick(((ConsoleTile)this).calcFuelUse());
                use.setTicksToDrain(1);
                if (this.flightTicks % 20 == 0) {
                    for (Subsystem sub2 : ((ConsoleTile)this).getSubSystems()) {
                        sub2.onFlightSecond();
                    }
                    for (Upgrade up : ((ConsoleTile)this).getUpgrades()) {
                        up.onFlightSecond();
                    }
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    Network.sendToAllAround((Object)new ConsoleUpdateMessage(DataTypes.FUEL, (ConsoleData)new Fuel(this.artron, this.max_artron)), (RegistryKey)this.field_145850_b.func_234923_W_(), (BlockPos)this.func_174877_v(), (int)20);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                if (!this.isBeingTowed && this.currentEvent != null && this.currentEvent.getMissedTime() < this.flightTicks) {
                    this.currentEvent.onComplete((ConsoleTile)this);
                    this.currentEvent = null;
                    if (this.landTime <= 0) {
                        ObjectWrapper collided = new ObjectWrapper((Object)false);
                        for (ServerWorld world : this.field_145850_b.func_73046_m().func_212370_w()) {
                            if (((Boolean)collided.getValue()).booleanValue()) break;
                            TardisHelper.getConsoleInWorld((World)world).ifPresent(tile -> ((ConsoleTile)this).getSubsystem(StabilizerSubsystem.class).ifPresent(sys -> {
                                if (tile != (ConsoleTile)this && tile.isInFlight() && !sys.isControlActivated() && tile.getLandTime() == 0 && !(tile.getFlightEvent() instanceof TardisCollideInstigate) && !(tile.getFlightEvent() instanceof TardisCollideRecieve) && tile.getPositionInFlight().getPos().func_218141_a((Vector3i)((ConsoleTile)this).getPositionInFlight().getPos(), (double)((Integer)TConfig.SERVER.collisionRange.get()).intValue())) {
                                    ((ConsoleTile)this).setFlightEvent((FlightEvent)((TardisCollideInstigate)((FlightEventFactory)FlightEventRegistry.COLLIDE_INSTIGATE.get()).create((ConsoleTile)this)).setOtherTARDIS(tile));
                                    collided.setValue((Object)true);
                                }
                            }));
                        }
                    }
                    if (((ConsoleTile)this).canGiveNewEvent() && this.currentEvent == null) {
                        ((ConsoleTile)this).setFlightEvent(FlightEventRegistry.getRandomEvent((Random)ConsoleTile.rand).create((ConsoleTile)this));
                    }
                } else if (this.currentEvent == null && ((ConsoleTile)this).canGiveNewEvent()) {
                    ((ConsoleTile)this).setFlightEvent(FlightEventRegistry.getRandomEvent((Random)ConsoleTile.rand).create((ConsoleTile)this));
                }
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 3L == 0L && this.currentEvent != null && !this.currentEvent.getControls().isEmpty()) {
                for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                    player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                        cap.setShaking(5);
                        cap.update();
                    });
                }
            }
        }
        ((ConsoleTile)this).playFlightLoop();
        if (!this.field_145850_b.field_72995_K && this.sparkLevel != SparkingLevel.NONE && this.field_145850_b.func_82737_E() % 60L == 0L && ((ConsoleTile)this).getEmotionHandler().getMood() > (double)EmotionHandler.EnumHappyState.DISCONTENT.getTreshold()) {
            ((ConsoleTile)this).getEmotionHandler().addMood(-1.0);
        }
    }
}

