/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.islands.variants;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.worldgen.islands.variants.AbstractSlimeIslandVariant;

public class BloodSlimeIslandVariant
extends AbstractSlimeIslandVariant {
    public BloodSlimeIslandVariant(int index) {
        super(index, SlimeType.ICHOR, SlimeType.BLOOD);
    }

    @Override
    public ResourceLocation getStructureName(String variantName) {
        return TConstruct.getResource("slime_islands/blood/" + variantName);
    }

    @Override
    protected SlimeType getCongealedSlimeType(Random random) {
        return random.nextBoolean() ? SlimeType.BLOOD : SlimeType.ICHOR;
    }

    @Override
    public BlockState getLakeFluid() {
        return Objects.requireNonNull(TinkerFluids.magma.getBlock()).func_176223_P();
    }

    @Override
    @Nullable
    public ConfiguredFeature<?, ?> getTreeFeature(Random random) {
        return TinkerStructures.BLOOD_SLIME_ISLAND_FUNGUS;
    }

    @Override
    public StructureProcessor getStructureProcessor() {
        return BlockIgnoreStructureProcessor.field_215206_c;
    }

    private static boolean isLava(ISeedReader world, BlockPos pos) {
        return world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }

    @Override
    public boolean isPositionValid(ISeedReader world, BlockPos pos, ChunkGenerator generator) {
        BlockPos up = pos.func_177984_a();
        if (BloodSlimeIslandVariant.isLava(world, up)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (BloodSlimeIslandVariant.isLava(world, up.func_177972_a(direction))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

