/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.item;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.SlimeVineBlock;

public class SlimeGrassSeedItem
extends TooltipItem {
    private final SlimeType foliage;

    public SlimeGrassSeedItem(Item.Properties properties, SlimeType foliage) {
        super(properties);
        this.foliage = foliage;
    }

    @Nullable
    private static SlimeType getSlimeType(Block block) {
        for (SlimeType type : SlimeType.values()) {
            if (TinkerWorld.allDirt.get((Enum)type) != block) continue;
            return type;
        }
        return null;
    }

    @Nullable
    private Block getVines() {
        switch (this.foliage) {
            case SKY: {
                return (Block)TinkerWorld.skySlimeVine.get();
            }
            case ENDER: {
                return (Block)TinkerWorld.enderSlimeVine.get();
            }
        }
        return null;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Block slimyVines;
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos);
        BlockState newState = null;
        if (state.func_177230_c() == Blocks.field_150395_bd && (slimyVines = this.getVines()) != null) {
            newState = (BlockState)slimyVines.func_176223_P().func_206870_a(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.START));
            for (BooleanProperty prop : VineBlock.field_196546_A.values()) {
                if (!((Boolean)state.func_177229_b((Property)prop)).booleanValue()) continue;
                newState = (BlockState)newState.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(true));
            }
        }
        if (newState == null) {
            SlimeType type = SlimeGrassSeedItem.getSlimeType(state.func_177230_c());
            if (type != null) {
                newState = ((Block)TinkerWorld.slimeGrass.get((Object)type).get((Enum)this.foliage)).func_176223_P();
            } else {
                return ActionResultType.PASS;
            }
        }
        if (!world.field_72995_K) {
            world.func_175656_a(pos, newState);
            world.func_184133_a(null, pos, newState.getSoundType((IWorldReader)world, pos, (Entity)context.func_195999_j()).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            PlayerEntity player = context.func_195999_j();
            if (player == null || !player.func_184812_l_()) {
                context.func_195996_i().func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.foliage != SlimeType.ICHOR) {
            super.func_150895_a(group, items);
        }
    }
}

