/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.HugeFungusConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.BloodSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.ClayIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EarthSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.EnderSlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SkySlimeIslandStructure;
import slimeknights.tconstruct.world.worldgen.islands.SlimeIslandPiece;
import slimeknights.tconstruct.world.worldgen.trees.SupplierBlockStateProvider;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeFungusConfig;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeFungusFeature;
import slimeknights.tconstruct.world.worldgen.trees.feature.SlimeTreeFeature;

public final class TinkerStructures
extends TinkerModule {
    private static boolean structureSettingsReady = false;
    static final Logger log = Util.getLogger("tinker_structures");
    public static final RegistryObject<BlockStateProviderType<SupplierBlockStateProvider>> supplierBlockstateProvider = BLOCK_STATE_PROVIDER_TYPES.register("supplier_state_provider", () -> new BlockStateProviderType(SupplierBlockStateProvider.CODEC));
    public static final RegistryObject<SlimeTreeFeature> SLIME_TREE = FEATURES.register("slime_tree", () -> new SlimeTreeFeature(SlimeTreeConfig.CODEC));
    public static final RegistryObject<SlimeFungusFeature> SLIME_FUNGUS = FEATURES.register("slime_fungus", () -> new SlimeFungusFeature(SlimeFungusConfig.CODEC));
    public static ConfiguredFeature<SlimeTreeConfig, ?> EARTH_SLIME_TREE;
    public static ConfiguredFeature<SlimeTreeConfig, ?> EARTH_SLIME_ISLAND_TREE;
    public static ConfiguredFeature<SlimeTreeConfig, ?> SKY_SLIME_TREE;
    public static ConfiguredFeature<SlimeTreeConfig, ?> SKY_SLIME_ISLAND_TREE;
    public static ConfiguredFeature<SlimeTreeConfig, ?> ENDER_SLIME_TREE;
    public static ConfiguredFeature<SlimeTreeConfig, ?> ENDER_SLIME_ISLAND_TREE;
    public static ConfiguredFeature<HugeFungusConfig, ?> BLOOD_SLIME_FUNGUS;
    public static ConfiguredFeature<HugeFungusConfig, ?> BLOOD_SLIME_ISLAND_FUNGUS;
    public static ConfiguredFeature<HugeFungusConfig, ?> ICHOR_SLIME_FUNGUS;
    public static IStructurePieceType slimeIslandPiece;
    public static final RegistryObject<Structure<NoFeatureConfig>> earthSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> EARTH_SLIME_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> skySlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> SKY_SLIME_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> clayIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> CLAY_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> bloodSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> BLOOD_SLIME_ISLAND;
    public static final RegistryObject<Structure<NoFeatureConfig>> endSlimeIsland;
    public static StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> END_SLIME_ISLAND;

    @SubscribeEvent
    void onFeaturesRegistry(RegistryEvent.Register<Feature<?>> event) {
        slimeIslandPiece = (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)TinkerStructures.resource("slime_island_piece"), SlimeIslandPiece::new);
    }

    private static void addStructureSettings(RegistryKey<DimensionSettings> key, Structure<?> structure, StructureSeparationSettings settings) {
        DimensionSettings dimensionSettings = (DimensionSettings)WorldGenRegistries.field_243658_j.func_230516_a_(key);
        if (dimensionSettings != null) {
            dimensionSettings.func_236108_a_().func_236195_a_().put(structure, settings);
        }
    }

    private static void addStructureToMap(Structure<?> structure) {
        Structure.field_236365_a_.put((Object)Objects.requireNonNull(structure.getRegistryName()).toString(), structure);
    }

    public static void addStructureSeparation() {
        if (!structureSettingsReady) {
            return;
        }
        StructureSeparationSettings earthSettings = new StructureSeparationSettings(((Integer)Config.COMMON.earthSlimeIslandSeparation.get()).intValue(), 5, 25988585);
        Map defaultStructures = DimensionSettings.func_242746_i().func_236108_a_().func_236195_a_();
        defaultStructures.put(earthSlimeIsland.get(), earthSettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242735_d, (Structure)earthSlimeIsland.get(), earthSettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242739_h, (Structure)earthSlimeIsland.get(), earthSettings);
        StructureSeparationSettings skySettings = new StructureSeparationSettings(((Integer)Config.COMMON.skySlimeIslandSeparation.get()).intValue(), 5, 14357800);
        defaultStructures.put(skySlimeIsland.get(), skySettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242735_d, (Structure)skySlimeIsland.get(), skySettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242739_h, (Structure)skySlimeIsland.get(), skySettings);
        StructureSeparationSettings claySettings = new StructureSeparationSettings(((Integer)Config.COMMON.clayIslandSeparation.get()).intValue(), 5, 162976988);
        defaultStructures.put(clayIsland.get(), claySettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242735_d, (Structure)clayIsland.get(), claySettings);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242739_h, (Structure)clayIsland.get(), claySettings);
        StructureSeparationSettings netherSettings = new StructureSeparationSettings(((Integer)Config.COMMON.bloodIslandSeparation.get()).intValue(), 5, 65245622);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242736_e, (Structure)bloodSlimeIsland.get(), netherSettings);
        StructureSeparationSettings endSettings = new StructureSeparationSettings(((Integer)Config.COMMON.endSlimeIslandSeparation.get()).intValue(), 5, 368963602);
        TinkerStructures.addStructureSettings((RegistryKey<DimensionSettings>)DimensionSettings.field_242737_f, (Structure)endSlimeIsland.get(), endSettings);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet ignore = Sets.newHashSet((Object[])new Structure[]{(Structure)earthSlimeIsland.get(), (Structure)skySlimeIsland.get(), (Structure)clayIsland.get(), (Structure)bloodSlimeIsland.get(), (Structure)endSlimeIsland.get()});
        builder.putAll((Iterable)DimensionStructuresSettings.field_236191_b_.entrySet().stream().filter(entry -> !ignore.contains(entry.getKey())).collect(Collectors.toList()));
        builder.put((Object)earthSlimeIsland.get(), (Object)earthSettings);
        builder.put((Object)skySlimeIsland.get(), (Object)skySettings);
        builder.put((Object)clayIsland.get(), (Object)claySettings);
        builder.put((Object)bloodSlimeIsland.get(), (Object)netherSettings);
        builder.put((Object)endSlimeIsland.get(), (Object)endSettings);
        DimensionStructuresSettings.field_236191_b_ = builder.build();
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TinkerStructures.addStructureToMap((Structure)earthSlimeIsland.get());
            TinkerStructures.addStructureToMap((Structure)skySlimeIsland.get());
            TinkerStructures.addStructureToMap((Structure)clayIsland.get());
            TinkerStructures.addStructureToMap((Structure)bloodSlimeIsland.get());
            TinkerStructures.addStructureToMap((Structure)endSlimeIsland.get());
        });
        structureSettingsReady = true;
        event.enqueueWork(TinkerStructures::addStructureSeparation);
        event.enqueueWork(() -> {
            EARTH_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.resource("earth_slime_island"), (Object)((Structure)earthSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            SKY_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.resource("sky_slime_island"), (Object)((Structure)skySlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            CLAY_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.resource("clay_island"), (Object)((Structure)clayIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            BLOOD_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.resource("blood_slime_island"), (Object)((Structure)bloodSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            END_SLIME_ISLAND = (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)TinkerStructures.resource("end_slime_island"), (Object)((Structure)endSlimeIsland.get()).func_236391_a_((IFeatureConfig)NoFeatureConfig.field_236559_b_));
            EARTH_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("earth_slime_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).func_176223_P()).baseHeight(4).randomHeight(3).build()));
            EARTH_SLIME_ISLAND_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("earth_slime_island_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.EARTH)).func_176223_P()).baseHeight(4).randomHeight(3).build()));
            SKY_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("sky_slime_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().planted().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).func_176223_P()).build()));
            SKY_SLIME_ISLAND_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("sky_slime_island_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().canDoubleHeight().trunk(() -> TinkerWorld.skyroot.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.SKY)).func_176223_P()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).func_176223_P().func_206870_a(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build()));
            ENDER_SLIME_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("ender_slime_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().planted().trunk(() -> TinkerWorld.greenheart.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).func_176223_P()).build()));
            ENDER_SLIME_ISLAND_TREE = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("ender_slime_island_tree"), (Object)((SlimeTreeFeature)SLIME_TREE.get()).func_225566_b_(new SlimeTreeConfig.Builder().trunk(() -> TinkerWorld.greenheart.getLog().func_176223_P()).leaves(() -> ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ENDER)).func_176223_P()).vines(() -> (BlockState)((SlimeVineBlock)TinkerWorld.enderSlimeVine.get()).func_176223_P().func_206870_a(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build()));
            BLOOD_SLIME_FUNGUS = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("blood_slime_fungus"), (Object)((SlimeFungusFeature)SLIME_FUNGUS.get()).func_225566_b_((IFeatureConfig)new SlimeFungusConfig((ITag<Block>)TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().func_176223_P(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).func_176223_P(), true)));
            BLOOD_SLIME_ISLAND_FUNGUS = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("blood_slime_island_fungus"), (Object)((SlimeFungusFeature)SLIME_FUNGUS.get()).func_225566_b_((IFeatureConfig)new SlimeFungusConfig((ITag<Block>)TinkerTags.Blocks.SLIMY_NYLIUM, TinkerWorld.bloodshroom.getLog().func_176223_P(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.BLOOD)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).func_176223_P(), false)));
            ICHOR_SLIME_FUNGUS = (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)TinkerStructures.resource("ichor_slime_fungus"), (Object)((SlimeFungusFeature)SLIME_FUNGUS.get()).func_225566_b_((IFeatureConfig)new SlimeFungusConfig((ITag<Block>)TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().func_176223_P(), ((Block)TinkerWorld.slimeLeaves.get((Enum)SlimeType.ICHOR)).func_176223_P(), ((CongealedSlimeBlock)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR)).func_176223_P(), false)));
        });
    }

    static {
        earthSlimeIsland = STRUCTURE_FEATURES.register("earth_slime_island", EarthSlimeIslandStructure::new);
        skySlimeIsland = STRUCTURE_FEATURES.register("overworld_slime_island", SkySlimeIslandStructure::new);
        clayIsland = STRUCTURE_FEATURES.register("clay_island", ClayIslandStructure::new);
        bloodSlimeIsland = STRUCTURE_FEATURES.register("nether_slime_island", BloodSlimeIslandStructure::new);
        endSlimeIsland = STRUCTURE_FEATURES.register("end_slime_island", EnderSlimeIslandStructure::new);
    }
}

