/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class SweepingEdgeModifier
extends IncrementalModifier {
    private static final ITextComponent SWEEPING_BONUS = TConstruct.makeTranslation("modifier", "sweeping_edge.attack_damage");

    public SweepingEdgeModifier() {
        super(0x888888);
    }

    public float getSweepingDamage(IModifierToolStack toolStack, float baseDamage) {
        int level = toolStack.getModifierLevel(this);
        float sweepingDamage = 1.0f;
        if (level > 4) {
            sweepingDamage += baseDamage;
        } else if (level > 0) {
            sweepingDamage += this.getScaledLevel(toolStack, level) * 0.25f * baseDamage;
        }
        return sweepingDamage;
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, List<ITextComponent> tooltip, boolean isAdvanced, boolean detailed) {
        float amount = this.getScaledLevel(tool, level) * 0.25f;
        tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.PERCENT_FORMAT.format(amount)).func_240702_b_(" ").func_230529_a_(SWEEPING_BONUS)));
    }
}

