/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.IncrementalModifier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class HydraulicModifier
extends IncrementalModifier {
    public HydraulicModifier() {
        super(8172452);
    }

    @Override
    public int getPriority() {
        return 125;
    }

    private static float getBonus(LivingEntity living) {
        float bonus = 0.0f;
        if (living.func_208600_a((ITag)FluidTags.field_206959_a)) {
            bonus = 8.0f;
        } else if (living.func_130014_f_().func_175727_C(living.func_233580_cy_())) {
            bonus = 4.0f;
        }
        return bonus;
    }

    @Override
    public void onBreakSpeed(IModifierToolStack tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!isEffective) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        float bonus = HydraulicModifier.getBonus((LivingEntity)player);
        if (bonus > 0.0f) {
            if (!ModifierUtil.hasAquaAffinity((LivingEntity)player) && player.func_208600_a((ITag)FluidTags.field_206959_a)) {
                bonus *= 5.0f;
            }
            event.setNewSpeed(event.getNewSpeed() + (bonus *= this.getScaledLevel(tool, level) * tool.getModifier(ToolStats.MINING_SPEED) * miningSpeedModifier));
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus = 8.0f;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = HydraulicModifier.getBonus((LivingEntity)player);
        }
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, (ITag<Item>)TinkerTags.Items.HARVEST, bonus * this.getScaledLevel(tool, level), tooltip);
    }
}

