/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.hooks.IArmorWalkModifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class SoulSpeedModifier
extends Modifier
implements IArmorWalkModifier {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("f61dde72-5b8d-11ec-bf63-0242ac130002");

    public SoulSpeedModifier() {
        super(5981496);
    }

    private static BlockPos getOnPosition(LivingEntity living) {
        BlockPos below;
        BlockState blockstate;
        int z;
        int y;
        Vector3d position = living.func_213303_ch();
        int x = MathHelper.func_76128_c((double)position.field_72450_a);
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(position.field_72448_b - (double)0.2f)), z = MathHelper.func_76128_c((double)position.field_72449_c));
        if (living.field_70170_p.func_175623_d(pos) && (blockstate = living.field_70170_p.func_180495_p(below = pos.func_177977_b())).collisionExtendsVertically((IBlockReader)living.field_70170_p, below, (Entity)living)) {
            return below;
        }
        return pos;
    }

    @Override
    public void onWalk(IModifierToolStack tool, int level, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (tool.isBroken() || !living.func_233570_aj_() || living.field_70170_p.field_72995_K) {
            return;
        }
        ModifiableAttributeInstance attribute = living.func_110148_a(Attributes.field_233821_d_);
        if (attribute == null) {
            return;
        }
        BlockPos belowPos = SoulSpeedModifier.getOnPosition(living);
        BlockState below = living.field_70170_p.func_180495_p(belowPos);
        if (below.func_196958_f()) {
            return;
        }
        if (attribute.func_111127_a(ATTRIBUTE_BONUS) != null) {
            attribute.func_188479_b(ATTRIBUTE_BONUS);
        }
        if (!living.func_184613_cA() && below.func_235714_a_((ITag)BlockTags.field_232876_aq_)) {
            Random rand = living.func_70681_au();
            float boost = 0.03f + (float)level * 0.0105f;
            float speedFactor = below.func_177230_c().func_226891_m_();
            if (speedFactor != 1.0f) {
                boost *= 1.0f / speedFactor;
            }
            attribute.func_233767_b_(new AttributeModifier(ATTRIBUTE_BONUS, "tconstruct.modifier.soul_speed", (double)boost, AttributeModifier.Operation.ADDITION));
            if (rand.nextFloat() < 0.04f) {
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlotType.FEET);
            }
            Vector3d motion = living.func_213322_ci();
            if (living.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)living.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_239812_C_, living.func_226277_ct_() + (rand.nextDouble() - 0.5) * (double)living.func_213311_cf(), living.func_226278_cu_() + 0.1, living.func_226281_cx_() + (rand.nextDouble() - 0.5) * (double)living.func_213311_cf(), 0, motion.field_72450_a * -0.2, 0.1, motion.field_72449_c * -0.2, 1.0);
            }
            living.field_70170_p.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_232831_nS_, living.func_184176_by(), rand.nextFloat() * 0.4f + rand.nextFloat() > 0.9f ? 0.6f : 0.0f, 0.6f + rand.nextFloat() * 0.4f);
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        ModifiableAttributeInstance attribute;
        IModifierToolStack newTool;
        LivingEntity livingEntity = context.getEntity();
        if (!livingEntity.field_70170_p.field_72995_K && context.getChangedSlot() == EquipmentSlotType.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || newTool.getModifierLevel(this) != level) && (attribute = livingEntity.func_110148_a(Attributes.field_233821_d_)) != null && attribute.func_111127_a(ATTRIBUTE_BONUS) != null) {
            attribute.func_188479_b(ATTRIBUTE_BONUS);
        }
    }

    @Override
    @Nullable
    public <T> T getModule(Class<T> type) {
        return SoulSpeedModifier.tryModuleMatch(type, IArmorWalkModifier.class, this);
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (player == null || key != TooltipKey.SHIFT || !player.func_184613_cA() && player.field_70170_p.func_180495_p(SoulSpeedModifier.getOnPosition((LivingEntity)player)).func_235714_a_((ITag)BlockTags.field_232876_aq_)) {
            this.addPercentTooltip(this.getDisplayName(), 0.3f + (float)level * 0.105f, tooltip);
        }
    }
}

