/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.SingleUseModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.library.utils.TooltipFlag;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.modifiers.traits.skull.ChrysophiliteModifier;

public class GoldGuardModifier
extends SingleUseModifier {
    private static final UUID GOLD_GUARD_UUID = UUID.fromString("fbae11f1-b547-47e8-ae0c-f2cf24a46d93");
    private static final TinkerDataCapability.ComputableDataKey<GoldGuardGold> TOTAL_GOLD = TConstruct.createKey("gold_guard", () -> new GoldGuardGold());

    public GoldGuardModifier() {
        super(16112170);
    }

    @Override
    public void onEquip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        if (context.getChangedSlot() == EquipmentSlotType.HEAD) {
            context.getTinkerData().ifPresent(data -> {
                GoldGuardGold gold = data.get(TOTAL_GOLD);
                if (gold == null) {
                    ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).initialize(context);
                } else {
                    gold.setGold(EquipmentSlotType.HEAD, tool.getVolatileData().getBoolean(ModifiableArmorItem.PIGLIN_NEUTRAL), context.getEntity());
                }
            });
        }
    }

    @Override
    public void onUnequip(IModifierToolStack tool, int level, EquipmentChangeContext context) {
        IModifierToolStack newTool;
        if (context.getChangedSlot() == EquipmentSlotType.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> data.remove(TOTAL_GOLD));
            ModifiableAttributeInstance instance = context.getEntity().func_110148_a(Attributes.field_233818_a_);
            if (instance != null) {
                instance.func_188479_b(GOLD_GUARD_UUID);
            }
        }
    }

    @Override
    public void onEquipmentChange(IModifierToolStack tool, int level, EquipmentChangeContext context, EquipmentSlotType slotType) {
        EquipmentSlotType changed = context.getChangedSlot();
        if (slotType == EquipmentSlotType.HEAD && changed.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            LivingEntity living = context.getEntity();
            boolean hasGold = ChrysophiliteModifier.hasGold(context, changed);
            context.getTinkerData().ifPresent(data -> ((GoldGuardGold)data.computeIfAbsent(TOTAL_GOLD)).setGold(changed, hasGold, living));
        }
    }

    @Override
    public void addInformation(IModifierToolStack tool, int level, @Nullable PlayerEntity player, List<ITextComponent> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AttributeModifier modifier;
        ModifiableAttributeInstance instance;
        if (player != null && tooltipKey == TooltipKey.SHIFT && (instance = player.func_110148_a(Attributes.field_233818_a_)) != null && (modifier = instance.func_111127_a(GOLD_GUARD_UUID)) != null) {
            tooltip.add((ITextComponent)this.applyStyle(new StringTextComponent(Util.BONUS_FORMAT.format(modifier.func_111164_d()) + " ").func_230529_a_((ITextComponent)new TranslationTextComponent(this.getTranslationKey() + ".health"))));
        }
    }

    private static class GoldGuardGold
    extends ChrysophiliteModifier.TotalGold {
        private GoldGuardGold() {
        }

        private void updateAttribute(LivingEntity living) {
            ModifiableAttributeInstance instance = living.func_110148_a(Attributes.field_233818_a_);
            if (instance != null) {
                if (instance.func_111127_a(GOLD_GUARD_UUID) != null) {
                    instance.func_188479_b(GOLD_GUARD_UUID);
                }
                instance.func_233767_b_(new AttributeModifier(GOLD_GUARD_UUID, "tconstruct.gold_guard", (double)(this.getTotalGold() * 4), AttributeModifier.Operation.ADDITION));
            }
        }

        public void setGold(EquipmentSlotType slotType, boolean value, LivingEntity living) {
            if (this.setGold(slotType, value)) {
                this.updateAttribute(living);
            }
        }

        @Override
        public void initialize(EquipmentChangeContext context) {
            super.initialize(context);
            this.updateAttribute(context.getEntity());
        }
    }
}

