/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.TankModifier;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.smeltery.tileentity.module.EntityMeltingModule;

public class MeltingModifier
extends TankModifier {
    private static final int MAX_TEMPERATURE = 1000;
    private static IMeltingRecipe lastRecipe = null;
    private static final MeltingInventory inventory = new MeltingInventory();

    public MeltingModifier() {
        super(16766976, 1296);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        return super.getDisplayName();
    }

    private static FluidStack meltItem(ItemStack stack, World world) {
        inventory.setStack(stack);
        IMeltingRecipe recipe = lastRecipe;
        if (recipe == null || !recipe.func_77569_a((IInventory)inventory, world)) {
            recipe = world.func_199532_z().func_215371_a(RecipeTypes.MELTING, (IInventory)inventory, world).orElse(null);
            if (recipe == null) {
                inventory.setStack(ItemStack.field_190927_a);
                return FluidStack.EMPTY;
            }
            lastRecipe = recipe;
        }
        FluidStack result = FluidStack.EMPTY;
        if (recipe.getTemperature(inventory) <= 1000) {
            result = recipe.getOutput(inventory);
        }
        inventory.setStack(ItemStack.field_190927_a);
        return result;
    }

    @Override
    public List<ItemStack> processLoot(IModifierToolStack tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        FluidStack current = this.getFluid(tool);
        int capacity = this.getCapacity(tool);
        if (current.getAmount() >= capacity) {
            return generatedLoot;
        }
        ServerWorld world = context.func_202879_g();
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        while (iterator.hasNext()) {
            FluidStack filled;
            int maxCopies;
            ItemStack stack = iterator.next();
            FluidStack output = MeltingModifier.meltItem(stack, (World)world);
            if (output.isEmpty() || !current.isEmpty() && !current.isFluidEqual(output) || (maxCopies = Math.min((capacity - current.getAmount()) / output.getAmount(), stack.func_190916_E())) <= 0 || (filled = this.fill(tool, current, output, output.getAmount() * maxCopies)).isEmpty()) continue;
            current = filled;
            stack.func_190918_g(maxCopies);
            if (!stack.func_190926_b()) continue;
            iterator.remove();
        }
        return generatedLoot;
    }

    @Override
    public int afterEntityHit(IModifierToolStack tool, int level, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (damageDealt > 0.0f && context.isFullyCharged() && (target = context.getLivingTarget()) != null) {
            int damagePerOutput;
            FluidStack output;
            EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(context.getAttacker().func_130014_f_().func_199532_z(), target.func_200600_R());
            if (recipe != null) {
                output = recipe.getOutput(target);
                damagePerOutput = recipe.getDamage();
            } else {
                output = EntityMeltingModule.getDefaultFluid();
                damagePerOutput = 2;
            }
            int fluidAmount = damageDealt < (float)(damagePerOutput * 2) ? (int)((float)output.getAmount() * damageDealt / (float)damagePerOutput) : output.getAmount() * 2;
            this.fill(tool, this.getFluid(tool), output, fluidAmount);
        }
        return 0;
    }

    private static class MeltingInventory
    implements IMeltingInventory {
        private ItemStack stack;

        private MeltingInventory() {
        }

        @Override
        public int getNuggetsPerOre() {
            return (Integer)Config.COMMON.melterNuggetsPerOre.get();
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

