/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor.walker;

import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ability.armor.walker.AbstractWalkerModifier;

public class BlockTransformWalkerModifier
extends AbstractWalkerModifier {
    private final ToolType toolType;
    private final SoundEvent sound;

    public BlockTransformWalkerModifier(int color, ToolType toolType, SoundEvent sound) {
        super(color);
        this.toolType = toolType;
        this.sound = sound;
    }

    @Override
    protected float getRadius(IModifierToolStack tool, int level) {
        return 1.5f + (float)tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
    }

    @Override
    public void onWalk(IModifierToolStack tool, int level, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (living instanceof PlayerEntity) {
            super.onWalk(tool, level, living, prevPos, newPos);
        }
    }

    @Override
    protected void walkOn(IModifierToolStack tool, int level, LivingEntity living, World world, BlockPos target, BlockPos.Mutable mutable) {
        Material material = world.func_180495_p(target).func_185904_a();
        if (material.func_76222_j() || material == Material.field_151585_k) {
            mutable.func_181079_c(target.func_177958_n(), target.func_177956_o() - 1, target.func_177952_p());
            BlockState original = world.func_180495_p((BlockPos)mutable);
            BlockState transformed = original.getToolModifiedState(world, (BlockPos)mutable, (PlayerEntity)living, living.func_184582_a(EquipmentSlotType.FEET), this.toolType);
            if (transformed != null) {
                world.func_180501_a((BlockPos)mutable, transformed, 11);
                world.func_175655_b(target, true);
                world.func_184133_a(null, (BlockPos)mutable, this.sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlotType.FEET);
            }
        }
    }
}

