/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class DoubleJumpModifier
extends TotalArmorLevelModifier {
    private static final ResourceLocation JUMPS = TConstruct.getResource("jumps");
    private static final TinkerDataCapability.TinkerDataKey<Integer> EXTRA_JUMPS = TConstruct.createKey("extra_jumps");
    private ITextComponent levelOneName = null;
    private ITextComponent levelTwoName = null;

    public DoubleJumpModifier() {
        super(117709, EXTRA_JUMPS);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, DoubleJumpModifier::onLand);
    }

    @Override
    public ITextComponent getDisplayName(int level) {
        if (level == 1) {
            if (this.levelOneName == null) {
                this.levelOneName = this.applyStyle((IFormattableTextComponent)new TranslationTextComponent(this.getTranslationKey() + ".double"));
            }
            return this.levelOneName;
        }
        if (level == 2) {
            if (this.levelTwoName == null) {
                this.levelTwoName = this.applyStyle((IFormattableTextComponent)new TranslationTextComponent(this.getTranslationKey() + ".triple"));
            }
            return this.levelTwoName;
        }
        return super.getDisplayName(level);
    }

    public static boolean extraJump(PlayerEntity entity) {
        int maxJumps;
        if (!(entity.func_233570_aj_() || entity.func_70617_f_() || entity.func_203005_aq() || (maxJumps = entity.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(EXTRA_JUMPS)).orElse(0).intValue()) <= 0)) {
            return entity.getCapability(PersistentDataCapability.CAPABILITY).filter(data -> {
                int jumps = data.getInt(JUMPS);
                if (jumps < maxJumps) {
                    entity.func_70664_aZ();
                    Random random = entity.func_130014_f_().func_201674_k();
                    for (int i = 0; i < 4; ++i) {
                        entity.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197632_y, entity.func_226277_ct_() - 0.25 + (double)(random.nextFloat() * 0.5f), entity.func_226278_cu_(), entity.func_226281_cx_() - 0.25 + (double)(random.nextFloat() * 0.5f), 0.0, 0.0, 0.0);
                    }
                    entity.func_184185_a(Sounds.EXTRA_JUMP.getSound(), 0.5f, 0.5f);
                    data.putInt(JUMPS, jumps + 1);
                    return true;
                }
                return false;
            }).isPresent();
        }
        return false;
    }

    private static void onLand(LivingFallEvent event) {
        event.getEntity().getCapability(PersistentDataCapability.CAPABILITY).ifPresent(data -> data.remove(JUMPS));
    }
}

