/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item.broad;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.helper.aoe.RectangleAOEHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IModifierToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.small.KamaTool;

public class ScytheTool
extends KamaTool {
    public static final ToolHarvestLogic HARVEST_LOGIC = new KamaTool.HarvestLogic(3, true){

        @Override
        public Iterable<BlockPos> getAOEBlocks(IModifierToolStack tool, ItemStack stack, PlayerEntity player, BlockState state, World world, BlockPos origin, Direction sideHit, ToolHarvestLogic.AOEMatchType matchType) {
            int expanded = tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
            int sides = (expanded + 1) / 2;
            return RectangleAOEHarvestLogic.calculate(this, tool, stack, world, player, origin, sideHit, 1 + sides, 1 + sides, 3 + expanded / 2 * 2, matchType);
        }
    };

    public ScytheTool(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    @Override
    public ToolHarvestLogic getToolHarvestLogic() {
        return HARVEST_LOGIC;
    }

    @Override
    public boolean dealDamage(IModifierToolStack tool, ToolAttackContext context, float damage) {
        boolean hit = super.dealDamage(tool, context, damage);
        if (context.isFullyCharged()) {
            double range = 3 + tool.getModifierLevel((Modifier)TinkerModifiers.expanded.get());
            LivingEntity attacker = context.getAttacker();
            Entity target = context.getTarget();
            for (LivingEntity aoeTarget : attacker.func_130014_f_().func_217357_a(LivingEntity.class, target.func_174813_aQ().func_72314_b(range, 0.25, range))) {
                if (aoeTarget == attacker || aoeTarget == target || attacker.func_184191_r((Entity)aoeTarget) || aoeTarget instanceof ArmorStandEntity && ((ArmorStandEntity)aoeTarget).func_181026_s() || !(attacker.func_70068_e((Entity)aoeTarget) < 8.0 + range)) continue;
                aoeTarget.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
                hit |= ToolAttackUtil.extraEntityAttack(this, tool, attacker, context.getHand(), (Entity)aoeTarget);
            }
            attacker.field_70170_p.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, attacker.func_184176_by(), 1.0f, 1.0f);
            if (attacker instanceof PlayerEntity) {
                ((PlayerEntity)attacker).func_184810_cG();
            }
        }
        return hit;
    }
}

