/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.inventory.ItemHandlerSlot;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.inventory.ReadOnlySlot;

public class ToolContainer
extends Container {
    public static final int SLOT_SIZE = 18;
    public static final int REPEAT_BACKGROUND_START = 17;
    private final ItemStack stack;
    private final IItemHandler itemHandler;
    private final PlayerEntity player;
    private final int selectedHotbarSlot;
    private final boolean showOffhand;
    private final int playerInventoryStart;

    public ToolContainer(int id, PlayerInventory playerInventory, ItemStack stack, IItemHandlerModifiable itemHandler, EquipmentSlotType slotType) {
        this((ContainerType)TinkerTools.toolContainer.get(), id, playerInventory, stack, (IItemHandler)itemHandler, slotType);
    }

    public static ToolContainer forClient(int id, PlayerInventory inventory, PacketBuffer buffer) {
        EquipmentSlotType slotType = (EquipmentSlotType)buffer.func_179257_a(EquipmentSlotType.class);
        ItemStack stack = inventory.field_70458_d.func_184582_a(slotType);
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(EmptyItemHandler.INSTANCE);
        return new ToolContainer((ContainerType)TinkerTools.toolContainer.get(), id, inventory, stack, handler, slotType);
    }

    protected ToolContainer(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, ItemStack stack, IItemHandler handler, EquipmentSlotType slotType) {
        super(type, id);
        int c;
        this.stack = stack;
        this.itemHandler = handler;
        this.player = playerInventory.field_70458_d;
        int slots = this.itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            this.func_75146_a((Slot)new ItemHandlerSlot(this.itemHandler, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
        this.showOffhand = ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.INCLUDE_OFFHAND);
        if (this.showOffhand) {
            int x = 8 + slots % 9 * 18;
            int y = 18 + slots / 9 * 18;
            if (slotType == EquipmentSlotType.OFFHAND) {
                this.func_75146_a(new ReadOnlySlot((IInventory)playerInventory, 40, x, y));
            } else {
                this.func_75146_a(new Slot((IInventory)playerInventory, 40, x, y));
            }
        }
        this.playerInventoryStart = this.field_75151_b.size();
        int playerY = 32 + 18 * ((slots + 8) / 9);
        for (int r = 0; r < 3; ++r) {
            for (c = 0; c < 9; ++c) {
                this.func_75146_a(new Slot((IInventory)playerInventory, c + r * 9 + 9, 8 + c * 18, playerY + r * 18));
            }
        }
        int hotbarStart = playerY + 58;
        this.selectedHotbarSlot = slotType == EquipmentSlotType.MAINHAND ? playerInventory.field_70461_c : (slotType == EquipmentSlotType.OFFHAND ? 10 : -1);
        for (c = 0; c < 9; ++c) {
            if (c == this.selectedHotbarSlot) {
                this.func_75146_a(new ReadOnlySlot((IInventory)playerInventory, c, 8 + c * 18, hotbarStart));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)playerInventory, c, 8 + c * 18, hotbarStart));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.player == playerIn;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            int end = this.field_75151_b.size();
            if (index < this.playerInventoryStart ? !this.func_75135_a(slotStack, this.playerInventoryStart, end, true) : !this.func_75135_a(slotStack, 0, this.playerInventoryStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return result;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public int getSelectedHotbarSlot() {
        return this.selectedHotbarSlot;
    }

    public boolean isShowOffhand() {
        return this.showOffhand;
    }
}

