/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity.tank;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.network.SmelteryTankUpdatePacket;
import slimeknights.tconstruct.smeltery.tileentity.tank.ISmelteryTankHandler;

public class SmelteryTank
implements IFluidHandler {
    private final ISmelteryTankHandler parent;
    private final List<FluidStack> fluids = Lists.newArrayList();
    private int capacity = 0;
    private int contained = 0;
    private static final String TAG_FLUIDS = "fluids";
    private static final String TAG_CAPACITY = "capacity";

    public SmelteryTank(ISmelteryTankHandler parent) {
        this.parent = parent;
    }

    public void syncFluids() {
        TileEntity te = this.parent.getTileEntity();
        World world = te.func_145831_w();
        if (world != null && !world.field_72995_K) {
            BlockPos pos = te.func_174877_v();
            TinkerNetwork.getInstance().sendToClientsAround(new SmelteryTankUpdatePacket(pos, this.fluids), (IWorld)world, pos);
        }
    }

    public void setCapacity(int maxCapacity) {
        this.capacity = maxCapacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getRemainingSpace() {
        if (this.contained >= this.capacity) {
            return 0;
        }
        return this.capacity - this.contained;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTanks() {
        if (this.contained < this.capacity) {
            return this.fluids.size() + 1;
        }
        return this.fluids.size();
    }

    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public int getTankCapacity(int tank) {
        if (tank < 0) {
            return 0;
        }
        int remaining = this.capacity - this.contained;
        if (tank == this.fluids.size()) {
            return remaining;
        }
        return this.fluids.get(tank).getAmount() + remaining;
    }

    public void moveFluidToBottom(int index) {
        if (index < this.fluids.size()) {
            FluidStack fluid = this.fluids.get(index);
            this.fluids.remove(index);
            this.fluids.add(0, fluid);
            this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, FluidStack.EMPTY);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.contained >= this.capacity || resource.isEmpty()) {
            return 0;
        }
        int usable = Math.min(this.capacity - this.contained, resource.getAmount());
        if (usable <= 0) {
            return 0;
        }
        if (action.simulate()) {
            return usable;
        }
        this.contained += usable;
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            fluid.grow(usable);
            this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            return usable;
        }
        resource = resource.copy();
        resource.setAmount(usable);
        this.fluids.add(resource);
        this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ADDED, resource);
        return usable;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.fluids.get(0);
        int drainable = Math.min(maxDrain, fluid.getAmount());
        FluidStack ret = fluid.copy();
        ret.setAmount(drainable);
        if (action.execute()) {
            fluid.shrink(drainable);
            this.contained -= drainable;
            if (fluid.getAmount() <= 0) {
                this.fluids.remove(fluid);
                this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
            } else {
                this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            }
        }
        return ret;
    }

    public FluidStack drain(FluidStack toDrain, IFluidHandler.FluidAction action) {
        ListIterator<FluidStack> iter = this.fluids.listIterator();
        while (iter.hasNext()) {
            FluidStack fluid = iter.next();
            if (!fluid.isFluidEqual(toDrain)) continue;
            int drainable = Math.min(toDrain.getAmount(), fluid.getAmount());
            FluidStack ret = fluid.copy();
            ret.setAmount(drainable);
            if (action.execute()) {
                fluid.shrink(drainable);
                this.contained -= drainable;
                if (fluid.getAmount() <= 0) {
                    iter.remove();
                    this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
                } else {
                    this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
                }
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public void setFluids(List<FluidStack> fluids) {
        FluidStack oldFirst = this.getFluidInTank(0);
        this.fluids.clear();
        this.fluids.addAll(fluids);
        this.contained = fluids.stream().mapToInt(FluidStack::getAmount).reduce(0, Integer::sum);
        FluidStack newFirst = this.getFluidInTank(0);
        if (!oldFirst.isFluidEqual(newFirst)) {
            this.parent.notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ORDER_CHANGED, newFirst);
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (FluidStack liquid : this.fluids) {
            CompoundNBT fluidTag = new CompoundNBT();
            liquid.writeToNBT(fluidTag);
            list.add((Object)fluidTag);
        }
        nbt.func_218657_a(TAG_FLUIDS, (INBT)list);
        nbt.func_74768_a(TAG_CAPACITY, this.capacity);
        return nbt;
    }

    public void read(CompoundNBT tag) {
        ListNBT list = tag.func_150295_c(TAG_FLUIDS, 10);
        this.fluids.clear();
        this.contained = 0;
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT fluidTag = list.func_150305_b(i);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
            if (fluid.isEmpty()) continue;
            this.fluids.add(fluid);
            this.contained += fluid.getAmount();
        }
        this.capacity = tag.func_74762_e(TAG_CAPACITY);
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public int getContained() {
        return this.contained;
    }
}

