/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.OptionalDouble;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.client.render.SmelteryTankRenderer;
import slimeknights.tconstruct.smeltery.tileentity.controller.HeatingStructureTileEntity;
import slimeknights.tconstruct.smeltery.tileentity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.tileentity.multiblock.HeatingStructureMultiblock;

public class HeatingStructureTileEntityRenderer
extends TileEntityRenderer<HeatingStructureTileEntity> {
    private static final RenderType ERROR_BLOCK = RenderType.func_228632_a_((String)"lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.empty())).func_228718_a_(RenderState.field_239235_M_).func_228726_a_(RenderState.field_228515_g_).func_228721_a_(RenderState.field_241712_U_).func_228727_a_(RenderState.field_228495_E_).func_228715_a_(RenderState.field_228492_B_).func_228728_a_(false));
    private static final float ITEM_SCALE = 0.9375f;

    public HeatingStructureTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(HeatingStructureTileEntity smeltery, float partialTicks, MatrixStack matrices, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = smeltery.func_145831_w();
        if (world == null) {
            return;
        }
        BlockState state = smeltery.func_195044_w();
        HeatingStructureMultiblock.StructureData structure = smeltery.getStructure();
        boolean structureValid = (Boolean)state.func_177229_b((Property)ControllerBlock.IN_STRUCTURE) != false && structure != null;
        BlockPos errorPos = smeltery.getErrorPos();
        if (errorPos != null && Minecraft.func_71410_x().field_71439_g != null) {
            boolean highlightError = smeltery.isHighlightError();
            if (!structureValid && highlightError || smeltery.showDebugBlockBorder((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                int dz;
                BlockPos pos = smeltery.func_174877_v();
                BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_233580_cy_();
                int dx = playerPos.func_177958_n() - pos.func_177958_n();
                if (dx * dx + (dz = playerPos.func_177952_p() - pos.func_177952_p()) * dz < 512) {
                    IVertexBuilder vertexBuilder = buffer.getBuffer((RenderType)(highlightError ? ERROR_BLOCK : RenderType.field_228614_Q_));
                    WorldRenderer.func_228445_b_((MatrixStack)matrices, (IVertexBuilder)vertexBuilder, (VoxelShape)VoxelShapes.func_197868_b(), (double)(errorPos.func_177958_n() - pos.func_177958_n()), (double)(errorPos.func_177956_o() - pos.func_177956_o()), (double)(errorPos.func_177952_p() - pos.func_177952_p()), (float)1.0f, (float)(structureValid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
                }
            }
        }
        if (!structureValid) {
            return;
        }
        BlockPos pos = smeltery.func_174877_v();
        BlockPos minPos = structure.getMinInside();
        BlockPos maxPos = structure.getMaxInside();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)(minPos.func_177958_n() - pos.func_177958_n()), (double)(minPos.func_177956_o() - pos.func_177956_o()), (double)(minPos.func_177952_p() - pos.func_177952_p()));
        SmelteryTankRenderer.renderFluids(matrices, buffer, smeltery.getTank(), minPos, maxPos, WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)minPos));
        int xd = 1 + maxPos.func_177958_n() - minPos.func_177958_n();
        int zd = 1 + maxPos.func_177952_p() - minPos.func_177952_p();
        int layer = xd * zd;
        Direction facing = (Direction)state.func_177229_b((Property)ControllerBlock.FACING);
        Quaternion itemRotation = Vector3f.field_229181_d_.func_229187_a_(-90.0f * (float)facing.func_176736_b());
        MeltingModuleInventory inventory = smeltery.getMeltingInventory();
        Minecraft mc = Minecraft.func_71410_x();
        ItemRenderer itemRenderer = mc.func_175599_af();
        int max = (Integer)Config.CLIENT.maxSmelteryItemQuads.get();
        if (max != 0) {
            int quadsRendered = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                int height = i / layer;
                int layerIndex = i % layer;
                int offsetX = layerIndex % xd;
                int offsetZ = layerIndex / xd;
                BlockPos itemPos = minPos.func_177982_a(offsetX, height, offsetZ);
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)((float)offsetX + 0.5f), (double)((float)height + 0.5f), (double)((float)offsetZ + 0.5f));
                matrices.func_227863_a_(itemRotation);
                matrices.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
                IBakedModel model = itemRenderer.func_184393_a(stack, world, null);
                itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrices, buffer, WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)itemPos), OverlayTexture.field_229196_a_, model);
                matrices.func_227865_b_();
                if (max == -1) continue;
                if (model.func_188618_c()) {
                    quadsRendered += 100;
                } else {
                    for (Direction direction : Direction.values()) {
                        quadsRendered += model.getQuads(null, direction, TConstruct.RANDOM, (IModelData)EmptyModelData.INSTANCE).size();
                    }
                    quadsRendered += model.getQuads(null, null, TConstruct.RANDOM, (IModelData)EmptyModelData.INSTANCE).size();
                }
                if (quadsRendered > max) break;
            }
        }
        matrices.func_227865_b_();
    }

    public boolean isGlobalRenderer(HeatingStructureTileEntity tile) {
        return (Boolean)tile.func_195044_w().func_177229_b((Property)ControllerBlock.IN_STRUCTURE) != false && tile.getStructure() != null;
    }
}

