/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public final class CopperCanModel
implements IModelGeometry<CopperCanModel> {
    public static final Loader LOADER = new Loader();
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final FluidStack fluid;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite coverSprite;
        FluidAttributes attributes = this.fluid.getFluid().getAttributes();
        TextureAtlasSprite fluidSprite = !this.fluid.isEmpty() ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)attributes.getStillTexture(this.fluid))) : null;
        RenderMaterial baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        TextureAtlasSprite textureAtlasSprite = coverSprite = (!this.coverIsMask || baseLocation != null) && owner.isTexturePresent("cover") ? spriteGetter.apply(owner.resolveTexture("cover")) : null;
        TextureAtlasSprite particleSprite = owner.isTexturePresent("particle") ? spriteGetter.apply(owner.resolveTexture("particle")) : (fluidSprite != null ? fluidSprite : (!this.coverIsMask && coverSprite != null ? coverSprite : spriteGetter.apply(ModelLoaderRegistry.blockMaterial((ResourceLocation)MissingTextureSprite.func_195675_b()))));
        IModelTransform transformsFromModel = owner.getCombinedTransform();
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(transformsFromModel, modelTransform));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrideList)new ContainedFluidOverrideHandler(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        TransformationMatrix transform = modelTransform.func_225615_b_();
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseLocation), (TransformationMatrix)transform, spriteGetter));
        }
        if (fluidSprite != null && owner.isTexturePresent("fluid") && (templateSprite = spriteGetter.apply(owner.resolveTexture("fluid"))) != null) {
            int luminosity = this.applyFluidLuminosity ? attributes.getLuminosity(this.fluid) : 0;
            int color = attributes.getColor(this.fluid);
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)-1, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)-1, (int)luminosity));
        }
        if (this.coverIsMask) {
            if (coverSprite != null) {
                TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.4685f, (Direction)Direction.NORTH, (int)-1, (int)2));
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((TransformationMatrix)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.5315f, (Direction)Direction.SOUTH, (int)-1, (int)2));
            }
        } else if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)coverSprite, (Direction)Direction.NORTH, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((TransformationMatrix)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (TextureAtlasSprite)coverSprite, (Direction)Direction.SOUTH, (int)-1, (int)2)});
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid")) {
            texs.add(owner.resolveTexture("fluid"));
        }
        if (owner.isTexturePresent("cover")) {
            texs.add(owner.resolveTexture("cover"));
        }
        return texs;
    }

    public CopperCanModel(@Nonnull FluidStack fluid, boolean coverIsMask, boolean applyFluidLuminosity) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        this.fluid = fluid;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public CopperCanModel withFluid(@Nonnull FluidStack fluid) {
        if (fluid == null) {
            throw new NullPointerException("fluid is marked non-null but is null");
        }
        return this.fluid == fluid ? this : new CopperCanModel(fluid, this.coverIsMask, this.applyFluidLuminosity);
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrideList {
        private static final ResourceLocation BAKE_LOCATION = TConstruct.getResource("copper_can_dynamic");
        private final Map<FluidStack, IBakedModel> cache = Maps.newHashMap();
        private final ItemOverrideList nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final CopperCanModel parent;

        private ContainedFluidOverrideHandler(ItemOverrideList nested, ModelBakery bakery, IModelConfiguration owner, CopperCanModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        private IBakedModel getUncahcedModel(FluidStack fluid) {
            return this.parent.withFluid(fluid).bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (IModelTransform)ModelRotation.X0_Y0, ItemOverrideList.field_188022_a, BAKE_LOCATION);
        }

        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
            IBakedModel overriden = this.nested.func_239290_a_(originalModel, stack, world, entity);
            if (overriden != originalModel) {
                return overriden;
            }
            Fluid fluid = CopperCanItem.getFluid(stack);
            if (fluid != Fluids.field_204541_a) {
                FluidStack fluidStack = new FluidStack(fluid, 144, CopperCanItem.getFluidTag(stack));
                return this.cache.computeIfAbsent(fluidStack, this::getUncahcedModel);
            }
            return originalModel;
        }
    }

    private static class Loader
    implements IModelLoader<CopperCanModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public CopperCanModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            boolean coverIsMask = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"coverIsMask", (boolean)true);
            boolean applyFluidLuminosity = JSONUtils.func_151209_a((JsonObject)modelContents, (String)"applyFluidLuminosity", (boolean)true);
            return new CopperCanModel(FluidStack.EMPTY, coverIsMask, applyFluidLuminosity);
        }
    }
}

