/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.render.FluidRenderer;
import slimeknights.tconstruct.shared.particle.FluidParticleData;

public class FluidParticle
extends SpriteTexturedParticle {
    private final FluidStack fluid;
    private final float uCoord;
    private final float vCoord;

    protected FluidParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, FluidStack fluid) {
        super(world, x, y, z, motionX, motionY, motionZ);
        this.fluid = fluid;
        FluidAttributes attributes = fluid.getFluid().getAttributes();
        this.func_217567_a(Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(attributes.getStillTexture(fluid)));
        this.field_70545_g = 1.0f;
        int color = attributes.getColor(fluid);
        this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
        this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
        this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(color & 0xFF) / 255.0f;
        this.field_70544_f /= 2.0f;
        this.uCoord = this.field_187136_p.nextFloat() * 3.0f;
        this.vCoord = this.field_187136_p.nextFloat() * 3.0f;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217601_a;
    }

    protected float func_217563_c() {
        return this.field_217569_E.func_94214_a((double)((this.uCoord + 1.0f) / 4.0f * 16.0f));
    }

    protected float func_217564_d() {
        return this.field_217569_E.func_94214_a((double)(this.uCoord / 4.0f * 16.0f));
    }

    protected float func_217562_e() {
        return this.field_217569_E.func_94207_b((double)(this.vCoord / 4.0f * 16.0f));
    }

    protected float func_217560_f() {
        return this.field_217569_E.func_94207_b((double)((this.vCoord + 1.0f) / 4.0f * 16.0f));
    }

    public int func_189214_a(float partialTick) {
        return FluidRenderer.withBlockLight((int)super.func_189214_a(partialTick), (int)this.fluid.getFluid().getAttributes().getLuminosity(this.fluid));
    }

    public static class Factory
    implements IParticleFactory<FluidParticleData> {
        public Particle makeParticle(FluidParticleData data, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FluidStack fluid = data.getFluid();
            return !fluid.isEmpty() ? new FluidParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, fluid) : null;
        }
    }
}

