/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.crt.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.melting.DamageableMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.OreMeltingRecipe;
import slimeknights.tconstruct.plugin.crt.CRTHelper;

@ZenRegister
@ZenCodeType.Name(value="mods.tconstruct.Melting")
public class MeltingManager
implements IRecipeManager {
    private void addMeltingRecipe(String name, IIngredient input, IFluidStack output, int temperature, int time, @ZenCodeType.Nullable List<IFluidStack> byProducts, MeltingRecipe.IFactory<?> factory) {
        name = this.fixRecipeName(name);
        if (byProducts == null) {
            byProducts = Collections.emptyList();
        }
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        Ingredient ingredient = input.asVanillaIngredient();
        FluidStack outputFluid = output.getInternal();
        List<FluidStack> byproductStacks = byProducts.stream().map(IFluidStack::getInternal).collect(Collectors.toList());
        Object recipe = factory.create(id, "", ingredient, outputFluid, temperature, time, byproductStacks);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, recipe));
    }

    @ZenCodeType.Method
    public void addMeltingRecipe(String name, IIngredient input, IFluidStack output, int temperature, int time, @ZenCodeType.Optional List<IFluidStack> byProducts) {
        this.addMeltingRecipe(name, input, output, temperature, time, byProducts, MeltingRecipe::new);
    }

    @ZenCodeType.Method
    public void addDamageableMeltingRecipe(String name, IIngredient input, IFluidStack output, int temperature, int time, @ZenCodeType.Optional List<IFluidStack> byProducts) {
        this.addMeltingRecipe(name, input, output, temperature, time, byProducts, DamageableMeltingRecipe::new);
    }

    @ZenCodeType.Method
    public void addOreMeltingRecipe(String name, IIngredient input, IFluidStack output, int temperature, int time, @ZenCodeType.Optional List<IFluidStack> byProducts) {
        this.addMeltingRecipe(name, input, output, temperature, time, byProducts, OreMeltingRecipe::new);
    }

    @ZenCodeType.Method
    public void addMaterialMeltingRecipe(String name, String inputId, IFluidStack output, int temperature) {
        name = this.fixRecipeName(name);
        ResourceLocation id = new ResourceLocation("crafttweaker", name);
        MaterialId inputMatId = CRTHelper.getMaterialId(inputId);
        MaterialMeltingRecipe recipe = new MaterialMeltingRecipe(id, inputMatId, temperature, output.getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)recipe));
    }

    public void removeRecipe(IItemStack output) {
        throw new IllegalArgumentException("Cannot remove Melting Recipes by an IItemStack output! Use `removeByName(String name)` instead!");
    }

    public IRecipeType<IMeltingRecipe> getRecipeType() {
        return RecipeTypes.MELTING;
    }
}

