/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class ModifierStatsBuilder {
    private boolean dirty = false;
    private final Map<IToolStat<?>, Object> map = new HashMap();

    public <B> void updateStat(IToolStat<B> stat, Consumer<B> consumer) {
        consumer.accept(this.map.computeIfAbsent(stat, IToolStat::makeBuilder));
        this.dirty = true;
    }

    private <B> float buildStat(IToolStat<B> stat, float value) {
        return stat.build(this.map.get(stat), value);
    }

    public StatsNBT build(StatsNBT base) {
        if (!this.dirty) {
            return base;
        }
        StatsNBT.Builder builder = StatsNBT.builder();
        Set<IToolStat<?>> existing = base.getContainedStats();
        for (IToolStat<?> stat : existing) {
            if (this.map.containsKey(stat)) {
                builder.set(stat, this.buildStat(stat, base.getFloat(stat)));
                continue;
            }
            builder.set(stat, base.getFloat(stat));
        }
        for (IToolStat<?> stat : this.map.keySet()) {
            if (existing.contains(stat)) continue;
            builder.set(stat, this.buildStat(stat, stat.getDefaultValue()));
        }
        return builder.build();
    }

    public StatsNBT buildMultipliers() {
        StatsNBT.Builder builder = StatsNBT.builder();
        for (Map.Entry<IToolStat<?>, Object> entry : this.map.entrySet()) {
            float multiplier;
            if (!(entry.getValue() instanceof FloatToolStat.FloatBuilder) || (multiplier = ((FloatToolStat.FloatBuilder)entry.getValue()).modifierMultiplier) == 1.0f) continue;
            builder.set(entry.getKey(), multiplier);
        }
        return builder.build();
    }

    private ModifierStatsBuilder() {
    }

    public static ModifierStatsBuilder builder() {
        return new ModifierStatsBuilder();
    }
}

