/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.item;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.ToolDefinition;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableHarvest;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolItem
extends ModifiableItem
implements IModifiableHarvest {
    public ToolItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (ToolDamageUtil.isBroken(stack)) {
            return Collections.emptySet();
        }
        return super.getToolTypes(stack);
    }

    public int getHarvestLevel(ItemStack stack, ToolType toolClass, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        if (this.getToolTypes(stack).contains(toolClass)) {
            return ToolStack.from(stack).getStats().getInt(ToolStats.HARVEST_LEVEL);
        }
        return -1;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return false;
        }
        if (!worldIn.field_72995_K && worldIn instanceof ServerWorld) {
            boolean isEffective = this.getToolHarvestLogic().isEffective(tool, stack, state);
            ToolHarvestContext context = new ToolHarvestContext((ServerWorld)worldIn, entityLiving, state, pos, Direction.UP, true, isEffective);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getModifier().afterBlockBreak(tool, entry.getLevel(), context);
            }
            ToolDamageUtil.damageAnimated(tool, this.getToolHarvestLogic().getDamage(tool, stack, worldIn, pos, state), entityLiving);
        }
        return true;
    }

    public final boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.getToolHarvestLogic().isEffective(ToolStack.from(stack), stack, state);
    }

    public final float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolHarvestLogic().getDestroySpeed(stack, state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return this.getToolHarvestLogic().handleBlockBreak(stack, pos, player);
    }
}

