/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.ToolBaseStatDefinition;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.definition.ToolStatProviders;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.part.IToolPart;

public class ToolDefinition {
    public static final ToolDefinition EMPTY = new ToolDefinition(TConstruct.getResource("empty"), new IToolStatProvider(){

        @Override
        public StatsNBT buildStats(ToolDefinition definition, List<IMaterial> materials) {
            return StatsNBT.EMPTY;
        }

        @Override
        public boolean isMultipart() {
            return false;
        }
    });
    private final ResourceLocation id;
    private final IToolStatProvider statProvider;
    private final int defaultMaxTier;
    protected ToolDefinitionData data;
    private int[] repairIndices;
    private Integer maxRepairWeight;
    @Nullable
    @Deprecated
    private ToolBaseStatDefinition baseStatDefinition;

    @Deprecated
    protected ToolDefinition(ResourceLocation id, IToolStatProvider statProvider) {
        this(id, statProvider, 1);
    }

    protected ToolDefinition(ResourceLocation id, IToolStatProvider statProvider, int defaultMaxTier) {
        this.id = id;
        this.statProvider = statProvider;
        this.defaultMaxTier = defaultMaxTier;
        this.data = statProvider.getDefaultData();
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static Builder builder(RegistryObject<? extends IItemProvider> item) {
        return ToolDefinition.builder(item.getId());
    }

    public static Builder builder(ItemObject<? extends IItemProvider> item) {
        return ToolDefinition.builder(item.getRegistryName());
    }

    public boolean isMultipart() {
        return this.statProvider.isMultipart();
    }

    public StatsNBT buildStats(List<IMaterial> materials) {
        return this.statProvider.buildStats(this, materials);
    }

    public int[] getRepairParts() {
        if (this.repairIndices == null) {
            List<PartRequirement> components = this.getData().getParts();
            if (components.isEmpty()) {
                this.repairIndices = new int[0];
            } else {
                IMaterialRegistry registry = MaterialRegistry.getInstance();
                this.repairIndices = IntStream.range(0, components.size()).filter(i -> registry.getDefaultStats(((PartRequirement)components.get(i)).getStatType()) instanceof IRepairableMaterialStats).toArray();
            }
        }
        return this.repairIndices;
    }

    public int getMaxRepairWeight() {
        if (this.maxRepairWeight == null) {
            int max = 1;
            List<PartRequirement> parts = this.getData().getParts();
            for (int i : this.getRepairParts()) {
                int cmp = parts.get(i).getWeight();
                if (cmp <= max) continue;
                max = cmp;
            }
            this.maxRepairWeight = max;
        }
        return this.maxRepairWeight;
    }

    public void validate(ToolDefinitionData data) {
        this.statProvider.validate(data);
    }

    public void setData(ToolDefinitionData data) {
        this.data = data;
        this.repairIndices = null;
        this.maxRepairWeight = null;
        this.baseStatDefinition = null;
    }

    public void setDefaultData() {
        this.setData(this.statProvider.getDefaultData());
    }

    public boolean isDataLoaded() {
        return this.data != this.statProvider.getDefaultData();
    }

    @Deprecated
    public ToolBaseStatDefinition getBaseStatDefinition() {
        if (this.baseStatDefinition == null) {
            this.baseStatDefinition = new ToolBaseStatDefinition(this.getData());
        }
        return this.baseStatDefinition;
    }

    @Deprecated
    public List<IToolPart> getRequiredComponents() {
        return this.getData().getParts().stream().map(PartRequirement::getPart).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Deprecated
    public List<ModifierEntry> getModifiers() {
        return this.getData().getTraits();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IToolStatProvider getStatProvider() {
        return this.statProvider;
    }

    public int getDefaultMaxTier() {
        return this.defaultMaxTier;
    }

    public ToolDefinitionData getData() {
        return this.data;
    }

    public static class Builder {
        private final ResourceLocation id;
        private IToolStatProvider statsProvider;
        private boolean register = true;
        private int defaultMaxTier = 1;

        public Builder meleeHarvest() {
            this.setStatsProvider(ToolStatProviders.MELEE_HARVEST);
            return this;
        }

        public Builder noParts() {
            this.setStatsProvider(ToolStatProviders.NO_PARTS);
            return this;
        }

        public Builder skipRegister() {
            this.register = false;
            return this;
        }

        public ToolDefinition build() {
            if (this.statsProvider == null) {
                throw new IllegalArgumentException("Stats provider is required for tools");
            }
            ToolDefinition definition = new ToolDefinition(this.id, this.statsProvider, this.defaultMaxTier);
            if (this.register) {
                ToolDefinitionLoader.getInstance().registerToolDefinition(definition);
            }
            return definition;
        }

        private Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder setStatsProvider(IToolStatProvider statsProvider) {
            this.statsProvider = statsProvider;
            return this;
        }

        public Builder setDefaultMaxTier(int defaultMaxTier) {
            this.defaultMaxTier = defaultMaxTier;
            return this;
        }
    }
}

