/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairCraftingRecipe
extends SpecialRecipe
implements ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final Modifier modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public ModifierRepairCraftingRecipe(ResourceLocation idIn, Modifier modifier, Ingredient ingredient, int repairAmount) {
        super(idIn);
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    @Nullable
    protected Pair<ToolStack, Integer> getRelevantInputs(CraftingInventory inv) {
        ToolStack tool = null;
        int itemsFound = 0;
        int modifierLevel = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (TinkerTags.Items.DURABILITY.func_230235_a_((Object)stack.func_77973_b())) {
                if (tool != null) {
                    return null;
                }
                tool = ToolStack.from(stack);
                if (!tool.isBroken() && tool.getDamage() == 0) {
                    return null;
                }
                modifierLevel = tool.getModifierLevel(this.modifier);
                if (modifierLevel != 0) continue;
                return null;
            }
            if (this.ingredient.test(stack)) {
                ++itemsFound;
                continue;
            }
            return null;
        }
        if (tool == null || itemsFound == 0) {
            return null;
        }
        return Pair.of(tool, (Object)(this.repairAmount * itemsFound * modifierLevel));
    }

    public boolean matches(CraftingInventory inv, World world) {
        return this.getRelevantInputs(inv) != null;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.func_199560_c());
            return ItemStack.field_190927_a;
        }
        float repairAmount = ((Integer)inputs.getSecond()).intValue();
        ToolStack tool = (ToolStack)inputs.getFirst();
        for (ModifierEntry entry : tool.getModifierList()) {
            repairAmount = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairAmount);
            if (!(repairAmount <= 0.0f)) continue;
            return ItemStack.field_190927_a;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, (int)repairAmount);
        return tool.createStack();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        Pair<ToolStack, Integer> inputs = this.getRelevantInputs(inv);
        int repairPerItem = 0;
        int repairNeeded = 0;
        if (inputs != null) {
            ToolStack tool = (ToolStack)inputs.getFirst();
            repairNeeded = tool.getDamage();
            float repairFloat = tool.getModifierLevel(this.modifier) * this.repairAmount;
            if (repairFloat > 0.0f) {
                ModifierEntry entry;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((repairFloat = (entry = iterator.next()).getModifier().getRepairFactor(tool, entry.getLevel(), repairFloat)) <= 0.0f)) {
                }
                repairPerItem = (int)repairFloat;
            }
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (this.ingredient.test(stack)) {
                if (repairNeeded <= 0) continue;
                repairNeeded -= repairPerItem;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerModifiers.craftingModifierRepair.get();
    }

    @Override
    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

