/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.partbuilder;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderInventory;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.ItemPartRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class PartRecipe
implements IPartBuilderRecipe,
IMultiRecipe<ItemPartRecipe> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Pattern pattern;
    protected final int cost;
    protected final IMaterialItem output;
    protected final int outputCount;
    @Nullable
    private List<ItemPartRecipe> multiRecipes;

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerTables.partRecipeSerializer.get();
    }

    @Override
    public boolean partialMatch(IPartBuilderInventory inv) {
        if (inv.getPatternStack().func_77973_b() != TinkerTables.pattern.get()) {
            return false;
        }
        if (!inv.getStack().func_190926_b()) {
            MaterialRecipe materialRecipe = inv.getMaterial();
            if (materialRecipe == null) {
                return false;
            }
            IMaterial material = materialRecipe.getMaterial();
            return material.isCraftable() && this.output.canUseMaterial(material);
        }
        return true;
    }

    public boolean matches(IPartBuilderInventory inv, World world) {
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            IMaterial material = materialRecipe.getMaterial();
            return material.isCraftable() && this.output.canUseMaterial(material) && inv.getStack().func_190916_E() >= materialRecipe.getItemsUsed(this.cost);
        }
        return false;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.output);
    }

    public ItemStack getRecipeOutput(IMaterial material) {
        ItemStack stack = this.output.withMaterial(material);
        stack.func_190920_e(this.outputCount);
        return stack;
    }

    public ItemStack getCraftingResult(IPartBuilderInventory inv) {
        IMaterial material = IMaterial.UNKNOWN;
        MaterialRecipe materialRecipe = inv.getMaterial();
        if (materialRecipe != null) {
            material = materialRecipe.getMaterial();
        }
        return this.getRecipeOutput(material);
    }

    public List<ItemPartRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = MaterialRegistry.getMaterials().stream().filter(mat -> mat.isCraftable() && this.output.canUseMaterial((IMaterial)mat)).map(mat -> new ItemPartRecipe(this.id, mat.getIdentifier(), this.pattern, this.getCost(), ItemOutput.fromStack((ItemStack)this.output.withMaterial((IMaterial)mat)))).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public PartRecipe(ResourceLocation id, String group, Pattern pattern, int cost, IMaterialItem output, int outputCount) {
        this.id = id;
        this.group = group;
        this.pattern = pattern;
        this.cost = cost;
        this.output = output;
        this.outputCount = outputCount;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public String func_193358_e() {
        return this.group;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getCost() {
        return this.cost;
    }
}

