/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.molding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import slimeknights.mantle.recipe.ICommonRecipe;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.molding.IMoldingInventory;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public abstract class MoldingRecipe
implements ICommonRecipe<IMoldingInventory> {
    private final ResourceLocation id;
    private final Ingredient material;
    private final Ingredient pattern;
    private final boolean patternConsumed;
    private final ItemOutput recipeOutput;

    public boolean matches(IMoldingInventory inv, World worldIn) {
        return this.material.test(inv.getMaterial()) && this.pattern.test(inv.getPattern());
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.material, this.pattern});
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput.get();
    }

    public MoldingRecipe(ResourceLocation id, Ingredient material, Ingredient pattern, boolean patternConsumed, ItemOutput recipeOutput) {
        this.id = id;
        this.material = material;
        this.pattern = pattern;
        this.patternConsumed = patternConsumed;
        this.recipeOutput = recipeOutput;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public Ingredient getPattern() {
        return this.pattern;
    }

    public boolean isPatternConsumed() {
        return this.patternConsumed;
    }

    public static class Serializer<T extends MoldingRecipe>
    extends LoggingRecipeSerializer<T> {
        private final IFactory<T> factory;

        public T read(ResourceLocation id, JsonObject json) {
            Ingredient material = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"material"));
            Ingredient pattern = Ingredient.field_193370_a;
            boolean patternConsumed = false;
            if (json.has("pattern")) {
                pattern = Ingredient.func_199802_a((JsonElement)json.get("pattern"));
                patternConsumed = JSONUtils.func_151209_a((JsonObject)json, (String)"pattern_consumed", (boolean)false);
            }
            ItemOutput output = ItemOutput.fromJson((JsonElement)json.get("result"));
            return this.factory.create(id, material, pattern, patternConsumed, output);
        }

        @Override
        @Nullable
        protected T readSafe(ResourceLocation id, PacketBuffer buffer) {
            Ingredient material = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient mold = Ingredient.func_199566_b((PacketBuffer)buffer);
            boolean moldConsumed = buffer.readBoolean();
            ItemOutput output = ItemOutput.read((PacketBuffer)buffer);
            return this.factory.create(id, material, mold, moldConsumed, output);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, MoldingRecipe recipe) {
            recipe.material.func_199564_a(buffer);
            recipe.pattern.func_199564_a(buffer);
            buffer.writeBoolean(recipe.patternConsumed);
            recipe.recipeOutput.write(buffer);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends MoldingRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, boolean var4, ItemOutput var5);
    }

    public static class Basin
    extends MoldingRecipe {
        public Basin(ResourceLocation id, Ingredient material, Ingredient mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.moldingBasinSerializer.get();
        }

        public IRecipeType<?> func_222127_g() {
            return RecipeTypes.MOLDING_BASIN;
        }
    }

    public static class Table
    extends MoldingRecipe {
        public Table(ResourceLocation id, Ingredient material, Ingredient mold, boolean moldConsumed, ItemOutput recipeOutput) {
            super(id, material, mold, moldConsumed, recipeOutput);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.moldingTableSerializer.get();
        }

        public IRecipeType<?> func_222127_g() {
            return RecipeTypes.MOLDING_TABLE;
        }
    }
}

