/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.spilling.effects;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffect;
import slimeknights.tconstruct.library.recipe.modifiers.spilling.effects.ISpillingEffectLoader;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;

public class CureEffectsSpillingEffect
implements ISpillingEffect {
    public static final Loader LOADER = new Loader();
    private final ItemStack stack;

    @Override
    public void applyEffects(FluidStack fluid, float scale, ToolAttackContext context) {
        LivingEntity target = context.getLivingTarget();
        if (target != null) {
            target.curePotionEffects(this.stack);
        }
    }

    @Override
    public ISpillingEffectLoader<?> getLoader() {
        return LOADER;
    }

    public CureEffectsSpillingEffect(ItemStack stack) {
        this.stack = stack;
    }

    private static class Loader
    implements ISpillingEffectLoader<CureEffectsSpillingEffect> {
        private Loader() {
        }

        @Override
        public CureEffectsSpillingEffect deserialize(JsonObject json) {
            ItemStack curativeItem = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            return new CureEffectsSpillingEffect(curativeItem);
        }

        @Override
        public CureEffectsSpillingEffect read(PacketBuffer buffer) {
            ItemStack curativeItem = buffer.func_150791_c();
            return new CureEffectsSpillingEffect(curativeItem);
        }

        @Override
        public void serialize(CureEffectsSpillingEffect effect, JsonObject json) {
            json.addProperty("item", Objects.requireNonNull(effect.stack.func_77973_b().getRegistryName()).toString());
            CompoundNBT nbt = effect.stack.func_77978_p();
            if (nbt != null) {
                json.addProperty("nbt", nbt.toString());
            }
        }

        @Override
        public void write(CureEffectsSpillingEffect effect, PacketBuffer buffer) {
            buffer.func_150788_a(effect.stack);
        }
    }
}

