/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.RecipeHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.IMeltingInventory;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialMeltingRecipe
implements IMeltingRecipe,
IMultiRecipe<MeltingRecipe> {
    private final ResourceLocation id;
    private final MaterialId inputId;
    private final int temperature;
    private final FluidStack result;
    private IMaterial input;
    private List<MeltingRecipe> multiRecipes = null;

    public IMaterial getInput() {
        if (this.input == null) {
            this.input = MaterialRegistry.getMaterial(this.inputId);
        }
        return this.input;
    }

    public boolean matches(IMeltingInventory inv, World worldIn) {
        IMaterial input = this.getInput();
        if (input == IMaterial.UNKNOWN) {
            return false;
        }
        ItemStack stack = inv.getStack();
        if (stack.func_190926_b() || MaterialCastingLookup.getItemCost(stack.func_77973_b()) == 0) {
            return false;
        }
        return IMaterialItem.getMaterialFromStack(stack) == input;
    }

    @Override
    public int getTemperature(IMeltingInventory inv) {
        return this.temperature;
    }

    @Override
    public int getTime(IMeltingInventory inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().func_77973_b());
        return IMeltingRecipe.calcTimeForAmount(this.temperature, this.result.getAmount() * cost);
    }

    @Override
    public FluidStack getOutput(IMeltingInventory inv) {
        int cost = MaterialCastingLookup.getItemCost(inv.getStack().func_77973_b());
        return new FluidStack(this.result, this.result.getAmount() * cost);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.materialMeltingSerializer.get();
    }

    public List<MeltingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            this.multiRecipes = this.getInput().isHidden() ? Collections.emptyList() : MaterialCastingLookup.getAllItemCosts().stream().filter(entry -> ((IMaterialItem)entry.getKey()).canUseMaterial(this.getInput())).map(entry -> {
                FluidStack output = this.result;
                if (entry.getIntValue() != 1) {
                    output = new FluidStack(output, output.getAmount() * entry.getIntValue());
                }
                return new MeltingRecipe(this.id, "", MaterialIngredient.fromItem((IMaterialItem)entry.getKey(), this.inputId), output, this.temperature, IMeltingRecipe.calcTimeForAmount(this.temperature, output.getAmount()), Collections.emptyList());
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public MaterialMeltingRecipe(ResourceLocation id, MaterialId inputId, int temperature, FluidStack result) {
        this.id = id;
        this.inputId = inputId;
        this.temperature = temperature;
        this.result = result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialMeltingRecipe> {
        public MaterialMeltingRecipe read(ResourceLocation id, JsonObject json) {
            MaterialId inputId = new MaterialId(JSONUtils.func_151200_h((JsonObject)json, (String)"input"));
            int temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            FluidStack output = RecipeHelper.deserializeFluidStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        @Override
        @Nullable
        protected MaterialMeltingRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            MaterialId inputId = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            int temperature = buffer.readInt();
            FluidStack output = FluidStack.readFromPacket((PacketBuffer)buffer);
            return new MaterialMeltingRecipe(id, inputId, temperature, output);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, MaterialMeltingRecipe recipe) {
            buffer.func_180714_a(recipe.inputId.toString());
            buffer.writeInt(recipe.temperature);
            recipe.result.writeToPacket(buffer);
        }
    }
}

