/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeSerializer
extends LoggingRecipeSerializer<MaterialRecipe> {
    private static final ItemOutput EMPTY = ItemOutput.fromStack((ItemStack)ItemStack.field_190927_a);

    public static MaterialId getMaterial(JsonObject json, String key) {
        String materialId = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        if (materialId.isEmpty()) {
            throw new JsonSyntaxException("Material ID at " + key + " must not be empty");
        }
        return new MaterialId(materialId);
    }

    public MaterialRecipe read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"ingredient"));
        int value = JSONUtils.func_151208_a((JsonObject)json, (String)"value", (int)1);
        int needed = JSONUtils.func_151208_a((JsonObject)json, (String)"needed", (int)1);
        MaterialId materialId = MaterialRecipeSerializer.getMaterial(json, "material");
        ItemOutput leftover = EMPTY;
        if (value > 1 && json.has("leftover")) {
            leftover = ItemOutput.fromJson((JsonElement)json.get("leftover"));
        }
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, new MaterialId(materialId), leftover);
    }

    @Override
    @Nullable
    protected MaterialRecipe readSafe(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int value = buffer.readInt();
        int needed = buffer.readInt();
        String materialId = buffer.func_150789_c(Short.MAX_VALUE);
        ItemOutput leftover = ItemOutput.read((PacketBuffer)buffer);
        return new MaterialRecipe(recipeId, group, ingredient, value, needed, new MaterialId(materialId), leftover);
    }

    @Override
    protected void writeSafe(PacketBuffer buffer, MaterialRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        recipe.ingredient.func_199564_a(buffer);
        buffer.writeInt(recipe.value);
        buffer.writeInt(recipe.needed);
        buffer.func_180714_a(recipe.materialId.toString());
        recipe.leftover.write(buffer);
    }
}

