/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.tconstruct.common.recipe.LoggingRecipeSerializer;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public class MaterialFluidRecipe
implements ICustomOutputRecipe<ICastingInventory> {
    private final ResourceLocation id;
    private final FluidIngredient fluid;
    private final int temperature;
    @Nullable
    private final MaterialId inputId;
    private final MaterialId outputId;
    private IMaterial input;
    private IMaterial output;

    public MaterialFluidRecipe(ResourceLocation id, FluidIngredient fluid, int temperature, @Nullable MaterialId inputId, MaterialId outputId) {
        this.id = id;
        this.fluid = fluid;
        this.temperature = temperature;
        this.inputId = inputId;
        this.outputId = outputId;
        MaterialCastingLookup.registerFluid(this);
    }

    public boolean matches(ICastingInventory inv) {
        if (this.getOutput() == IMaterial.UNKNOWN || !this.fluid.test(inv.getFluid())) {
            return false;
        }
        if (this.inputId != null) {
            if (this.getInput() == IMaterial.UNKNOWN) {
                return false;
            }
            ItemStack stack = inv.getStack();
            return !stack.func_190926_b() && IMaterialItem.getMaterialIdFromStack(stack).equals((Object)this.getInputId());
        }
        return true;
    }

    public int getFluidAmount(Fluid fluid) {
        return this.fluid.getAmount(fluid);
    }

    public IMaterial getOutput() {
        if (!MaterialRegistry.isFullyLoaded()) {
            return IMaterial.UNKNOWN;
        }
        if (this.output == null) {
            this.output = MaterialRegistry.getMaterial(this.outputId);
        }
        return this.output;
    }

    @Nullable
    public IMaterial getInput() {
        if (this.inputId == null) {
            return null;
        }
        if (!MaterialRegistry.isFullyLoaded()) {
            return IMaterial.UNKNOWN;
        }
        if (this.input == null) {
            this.input = MaterialRegistry.getMaterial(this.inputId);
        }
        return this.input;
    }

    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public final boolean matches(ICastingInventory inv, World worldIn) {
        return this.matches(inv);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)TinkerSmeltery.materialFluidRecipe.get();
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.DATA;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @Nullable
    public MaterialId getInputId() {
        return this.inputId;
    }

    public MaterialId getOutputId() {
        return this.outputId;
    }

    public static class Serializer
    extends LoggingRecipeSerializer<MaterialFluidRecipe> {
        public MaterialFluidRecipe read(ResourceLocation id, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            int temperature = JSONUtils.func_151203_m((JsonObject)json, (String)"temperature");
            MaterialId input = null;
            if (json.has("input")) {
                input = new MaterialId(JSONUtils.func_151200_h((JsonObject)json, (String)"input"));
            }
            MaterialId output = new MaterialId(JSONUtils.func_151200_h((JsonObject)json, (String)"output"));
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        @Override
        @Nullable
        protected MaterialFluidRecipe readSafe(ResourceLocation id, PacketBuffer buffer) {
            FluidIngredient fluid = FluidIngredient.read((PacketBuffer)buffer);
            int temperature = buffer.readInt();
            MaterialId input = null;
            if (buffer.readBoolean()) {
                input = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            }
            MaterialId output = new MaterialId(buffer.func_150789_c(Short.MAX_VALUE));
            return new MaterialFluidRecipe(id, fluid, temperature, input, output);
        }

        @Override
        protected void writeSafe(PacketBuffer buffer, MaterialFluidRecipe recipe) {
            recipe.fluid.write(buffer);
            buffer.writeInt(recipe.temperature);
            if (recipe.inputId != null) {
                buffer.writeBoolean(true);
                buffer.func_180714_a(recipe.inputId.toString());
            } else {
                buffer.writeBoolean(false);
            }
            buffer.func_180714_a(recipe.outputId.toString());
        }
    }
}

