/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class ItemCastingRecipeBuilder
extends AbstractRecipeBuilder<ItemCastingRecipeBuilder> {
    private final ItemOutput result;
    private final ItemCastingRecipe.Serializer<?> recipeSerializer;
    private Ingredient cast = Ingredient.field_193370_a;
    private FluidIngredient fluid = FluidIngredient.EMPTY;
    private int coolingTime = -1;
    private boolean consumed = false;
    private boolean switchSlots = false;

    public static ItemCastingRecipeBuilder basinRecipe(ItemOutput result) {
        return ItemCastingRecipeBuilder.castingRecipe(result, (ItemCastingRecipe.Serializer)TinkerSmeltery.basinRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder basinRecipe(IItemProvider resultIn) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromItem((IItemProvider)resultIn));
    }

    public static ItemCastingRecipeBuilder basinRecipe(ITag<Item> result) {
        return ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(result, (int)1));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ItemOutput resultIn) {
        return ItemCastingRecipeBuilder.castingRecipe(resultIn, (ItemCastingRecipe.Serializer)TinkerSmeltery.tableRecipeSerializer.get());
    }

    public static ItemCastingRecipeBuilder tableRecipe(IItemProvider resultIn) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromItem((IItemProvider)resultIn));
    }

    public static ItemCastingRecipeBuilder tableRecipe(ITag<Item> result) {
        return ItemCastingRecipeBuilder.tableRecipe(ItemOutput.fromTag(result, (int)1));
    }

    public ItemCastingRecipeBuilder setFluid(ITag<Fluid> tagIn, int amount) {
        return this.setFluid(FluidIngredient.of(tagIn, (int)amount));
    }

    public ItemCastingRecipeBuilder setFluid(FluidIngredient fluid) {
        this.fluid = fluid;
        return this;
    }

    public ItemCastingRecipeBuilder setCoolingTime(int temperature, int amount) {
        this.setCoolingTime(ICastingRecipe.calcCoolingTime(temperature, amount));
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidStack fluidStack) {
        this.fluid = FluidIngredient.of((FluidStack)fluidStack);
        if (this.coolingTime == -1) {
            this.coolingTime = ICastingRecipe.calcCoolingTime(fluidStack);
        }
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(int temperature, ITag<Fluid> tagIn, int amount) {
        this.setFluid(tagIn, amount);
        this.setCoolingTime(temperature, amount);
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, boolean forgeTag, int amount) {
        this.setFluid((ITag<Fluid>)(forgeTag ? fluid.getForgeTag() : fluid.getLocalTag()), amount);
        this.setCoolingTime(fluid.get().getAttributes().getTemperature() - 300, amount);
        return this;
    }

    public ItemCastingRecipeBuilder setFluidAndTime(FluidObject<?> fluid, int amount) {
        return this.setFluidAndTime(fluid, false, amount);
    }

    public ItemCastingRecipeBuilder setCast(ITag<Item> tagIn, boolean consumed) {
        return this.setCast(Ingredient.func_199805_a(tagIn), consumed);
    }

    public ItemCastingRecipeBuilder setCast(IItemProvider itemIn, boolean consumed) {
        return this.setCast(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemIn}), consumed);
    }

    public ItemCastingRecipeBuilder setCast(Ingredient ingredient, boolean consumed) {
        this.cast = ingredient;
        this.consumed = consumed;
        return this;
    }

    public ItemCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Objects.requireNonNull(this.result.get().func_77973_b().getRegistryName()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.fluid == FluidIngredient.EMPTY) {
            throw new IllegalStateException("Casting recipes require a fluid input");
        }
        if (this.coolingTime < 0) {
            throw new IllegalStateException("Cooling time is too low, must be at least 0");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        consumer.accept((IFinishedRecipe)new Result(id, advancementId));
    }

    private ItemCastingRecipeBuilder(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        this.result = result;
        this.recipeSerializer = recipeSerializer;
    }

    public static ItemCastingRecipeBuilder castingRecipe(ItemOutput result, ItemCastingRecipe.Serializer<?> recipeSerializer) {
        return new ItemCastingRecipeBuilder(result, recipeSerializer);
    }

    public ItemCastingRecipeBuilder setCoolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    private class Result
    extends AbstractRecipeBuilder.AbstractFinishedRecipe {
        public Result(@Nullable ResourceLocation ID, ResourceLocation advancementID) {
            super((AbstractRecipeBuilder)ItemCastingRecipeBuilder.this, ID, advancementID);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ItemCastingRecipeBuilder.this.recipeSerializer;
        }

        public void func_218610_a(JsonObject json) {
            if (!ItemCastingRecipeBuilder.this.group.isEmpty()) {
                json.addProperty("group", ItemCastingRecipeBuilder.this.group);
            }
            if (ItemCastingRecipeBuilder.this.cast != Ingredient.field_193370_a) {
                json.add("cast", ItemCastingRecipeBuilder.this.cast.func_200304_c());
                if (ItemCastingRecipeBuilder.this.consumed) {
                    json.addProperty("cast_consumed", Boolean.valueOf(true));
                }
            }
            if (ItemCastingRecipeBuilder.this.switchSlots) {
                json.addProperty("switch_slots", Boolean.valueOf(true));
            }
            json.add("fluid", ItemCastingRecipeBuilder.this.fluid.serialize());
            json.add("result", ItemCastingRecipeBuilder.this.result.serialize());
            json.addProperty("cooling_time", (Number)ItemCastingRecipeBuilder.this.coolingTime);
        }
    }
}

