/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.FluidIngredient;
import slimeknights.mantle.recipe.ItemOutput;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.recipe.RecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.recipe.ICastingInventory;

public abstract class ItemCastingRecipe
extends AbstractCastingRecipe
implements IDisplayableCastingRecipe {
    protected final FluidIngredient fluid;
    protected final ItemOutput result;
    protected final int coolingTime;

    public ItemCastingRecipe(IRecipeType<?> type, ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
        super(type, id, group, cast, consumed, switchSlots);
        this.fluid = fluid;
        this.result = result;
        this.coolingTime = coolingTime;
    }

    @Override
    public int getFluidAmount(ICastingInventory inv) {
        return this.fluid.getAmount(inv.getFluid());
    }

    public boolean matches(ICastingInventory inv, World worldIn) {
        return this.getCast().test(inv.getStack()) && this.fluid.test(inv.getFluid());
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.get();
    }

    @Override
    public int getCoolingTime(ICastingInventory inv) {
        return this.coolingTime;
    }

    @Override
    public boolean hasCast() {
        return this.cast != Ingredient.field_193370_a;
    }

    @Override
    public List<ItemStack> getCastItems() {
        return Arrays.asList(this.cast.func_193365_a());
    }

    @Override
    public ItemStack getOutput() {
        return this.result.get();
    }

    @Override
    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public FluidIngredient getFluid() {
        return this.fluid;
    }

    @Override
    public int getCoolingTime() {
        return this.coolingTime;
    }

    public static interface IFactory<T extends AbstractCastingRecipe> {
        public T create(ResourceLocation var1, String var2, @Nullable Ingredient var3, FluidIngredient var4, ItemOutput var5, int var6, boolean var7, boolean var8);
    }

    public static class Serializer<T extends ItemCastingRecipe>
    extends AbstractCastingRecipe.Serializer<T> {
        private final IFactory<T> factory;

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, JsonObject json) {
            FluidIngredient fluid = FluidIngredient.deserialize((JsonObject)json, (String)"fluid");
            ItemOutput output = ItemOutput.fromJson((JsonElement)JsonHelper.getElement((JsonObject)json, (String)"result"));
            int coolingTime = JSONUtils.func_151203_m((JsonObject)json, (String)"cooling_time");
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, output, coolingTime, consumed, switchSlots));
        }

        @Override
        protected T create(ResourceLocation idIn, String groupIn, @Nullable Ingredient cast, boolean consumed, boolean switchSlots, PacketBuffer buffer) {
            FluidIngredient fluid = FluidIngredient.read((PacketBuffer)buffer);
            ItemOutput result = ItemOutput.read((PacketBuffer)buffer);
            int coolingTime = buffer.readInt();
            return (T)((ItemCastingRecipe)this.factory.create(idIn, groupIn, cast, fluid, result, coolingTime, consumed, switchSlots));
        }

        @Override
        public void writeExtra(PacketBuffer buffer, T recipe) {
            ((ItemCastingRecipe)recipe).fluid.write(buffer);
            ((ItemCastingRecipe)recipe).result.write(buffer);
            buffer.writeInt(((ItemCastingRecipe)recipe).coolingTime);
        }

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }
    }

    public static class Table
    extends ItemCastingRecipe {
        public Table(ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_TABLE, id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.tableRecipeSerializer.get();
        }
    }

    public static class Basin
    extends ItemCastingRecipe {
        public Basin(ResourceLocation id, String group, Ingredient cast, FluidIngredient fluid, ItemOutput result, int coolingTime, boolean consumed, boolean switchSlots) {
            super(RecipeTypes.CASTING_BASIN, id, group, cast, fluid, result, coolingTime, consumed, switchSlots);
        }

        public IRecipeSerializer<?> func_199559_b() {
            return (IRecipeSerializer)TinkerSmeltery.basinRecipeSerializer.get();
        }
    }
}

