/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.common.registration.MetalItemObject;
import slimeknights.tconstruct.library.data.recipe.IRecipeHelper;

public interface ICommonRecipeHelper
extends IRecipeHelper {
    default public void packingRecipe(Consumer<IFinishedRecipe> consumer, String largeName, IItemProvider large, String smallName, IItemProvider small, String folder) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)large).func_200462_a(Character.valueOf('#'), small).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)small)).func_200473_b(Objects.requireNonNull(large.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, this.wrap((IForgeRegistryEntry<?>)large.func_199767_j(), folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)small, (int)9).func_200487_b(large).func_200483_a("has_item", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)large)).func_200490_a(Objects.requireNonNull(small.func_199767_j().getRegistryName()).toString()).func_200485_a(consumer, this.wrap((IForgeRegistryEntry<?>)small.func_199767_j(), folder, String.format("_from_%s", largeName)));
    }

    default public void packingRecipe(Consumer<IFinishedRecipe> consumer, String largeName, IItemProvider largeItem, String smallName, IItemProvider smallItem, ITag<Item> smallTag, String folder) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)largeItem).func_200469_a(Character.valueOf('#'), smallTag).func_200462_a(Character.valueOf('*'), smallItem).func_200472_a("###").func_200472_a("#*#").func_200472_a("###").func_200465_a("has_item", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)smallItem)).func_200473_b(Objects.requireNonNull(largeItem.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, this.wrap((IForgeRegistryEntry<?>)largeItem.func_199767_j(), folder, String.format("_from_%ss", smallName)));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)smallItem, (int)9).func_200487_b(largeItem).func_200483_a("has_item", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)largeItem)).func_200490_a(Objects.requireNonNull(smallItem.func_199767_j().getRegistryName()).toString()).func_200485_a(consumer, this.wrap((IForgeRegistryEntry<?>)smallItem.func_199767_j(), folder, String.format("_from_%s", largeName)));
    }

    default public void metalCrafting(Consumer<IFinishedRecipe> consumer, MetalItemObject metal, String folder) {
        Item ingot = metal.getIngot();
        this.packingRecipe(consumer, "block", (IItemProvider)metal.get(), "ingot", (IItemProvider)ingot, (ITag<Item>)metal.getIngotTag(), folder);
        this.packingRecipe(consumer, "ingot", (IItemProvider)ingot, "nugget", (IItemProvider)metal.getNugget(), (ITag<Item>)metal.getNuggetTag(), folder);
    }

    default public void slabStairsCrafting(Consumer<IFinishedRecipe> consumer, BuildingBlockObject building, String folder, boolean addStonecutter) {
        Item item = building.func_199767_j();
        InventoryChangeTrigger.Instance hasBlock = RecipeProvider.func_200403_a((IItemProvider)item);
        SlabBlock slab = building.getSlab();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(slab.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_slab"));
        StairsBlock stairs = building.getStairs();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("B  ").func_200472_a("BB ").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(stairs.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_stairs"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            SingleItemRecipeBuilder.func_218644_a((Ingredient)ingredient, (IItemProvider)slab, (int)2).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_slab_stonecutter"));
            SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)stairs).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_stairs_stonecutter"));
        }
    }

    default public void stairSlabWallCrafting(Consumer<IFinishedRecipe> consumer, WallBuildingBlockObject building, String folder, boolean addStonecutter) {
        this.slabStairsCrafting(consumer, (BuildingBlockObject)building, folder, addStonecutter);
        Item item = building.func_199767_j();
        InventoryChangeTrigger.Instance hasBlock = RecipeProvider.func_200403_a((IItemProvider)item);
        WallBlock wall = building.getWall();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wall, (int)6).func_200462_a(Character.valueOf('B'), (IItemProvider)item).func_200472_a("BBB").func_200472_a("BBB").func_200465_a("has_item", (ICriterionInstance)hasBlock).func_200473_b(Objects.requireNonNull(wall.func_199767_j().getRegistryName()).toString()).func_200467_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_wall"));
        if (addStonecutter) {
            Ingredient ingredient = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
            SingleItemRecipeBuilder.func_218648_a((Ingredient)ingredient, (IItemProvider)wall).func_218643_a("has_item", (ICriterionInstance)hasBlock).func_218647_a(consumer, this.wrap((IForgeRegistryEntry<?>)item, folder, "_wall_stonecutter"));
        }
    }

    default public void woodCrafting(Consumer<IFinishedRecipe> consumer, WoodBlockObject wood, String folder) {
        InventoryChangeTrigger.Instance hasPlanks = RecipeProvider.func_200403_a((IItemProvider)wood);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)wood, (int)4).func_203221_a((ITag)wood.getLogItemTag()).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)RecipeProvider.func_200405_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)wood.getLogItemTag()).func_200310_b()})).func_200485_a(consumer, this.modResource(folder + "planks"));
        SlabBlock slab = wood.getSlab();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200473_b("wooden_slab").func_200467_a(consumer, this.modResource(folder + "slab"));
        StairsBlock stairs = wood.getStairs();
        ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200473_b("wooden_stairs").func_200467_a(consumer, this.modResource(folder + "stairs"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getWood(), (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)wood.getLog()).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)wood.getLog())).func_200467_a(consumer, this.modResource(folder + "log_to_wood"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getStrippedWood(), (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)wood.getStrippedLog()).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)wood.getStrippedLog())).func_200467_a(consumer, this.modResource(folder + "stripped_log_to_wood"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getFence(), (int)3).func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.RODS_WOODEN).func_200462_a(Character.valueOf('W'), (IItemProvider)wood).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200467_a(consumer, this.modResource(folder + "fence"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)wood.getFenceGate()).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)wood).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200467_a(consumer, this.modResource(folder + "fence_gate"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getDoor(), (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200467_a(consumer, this.modResource(folder + "door"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getTrapdoor(), (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200467_a(consumer, this.modResource(folder + "trapdoor"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)wood.getButton()).func_200487_b((IItemProvider)wood).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)hasPlanks).func_200485_a(consumer, this.modResource(folder + "button"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)wood.getPressurePlate()).func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)hasPlanks).func_200467_a(consumer, this.modResource(folder + "pressure_plate"));
        ShapedRecipeBuilder.func_200468_a((IItemProvider)wood.getSign(), (int)3).func_200473_b("sign").func_200462_a(Character.valueOf('#'), (IItemProvider)wood).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_planks", (ICriterionInstance)RecipeProvider.func_200403_a((IItemProvider)wood)).func_200467_a(consumer, this.modResource(folder + "sign"));
    }
}

