/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.block.TankModel;
import slimeknights.tconstruct.smeltery.tileentity.tank.IDisplayFluidListener;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static final Loader LOADER = new Loader();
    private final SimpleBlockModel model;
    private final Set<String> fluids;

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getTextures(owner, modelGetter, missingTextureErrors);
    }

    private static String trimTextureName(String name) {
        if (name.charAt(0) == '#') {
            return name.substring(1);
        }
        return name;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform transform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IBakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, modelLocation);
        Set fluidTextures = RetexturedModel.getAllRetextured((IModelConfiguration)owner, (SimpleBlockModel)this.model, this.fluids);
        List elements = this.model.getElements();
        int size = elements.size();
        BitSet fluidParts = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            BlockPart part = (BlockPart)elements.get(i);
            long fluidFaces = part.field_178240_c.values().stream().filter(face -> fluidTextures.contains(FluidTextureModel.trimTextureName(face.field_178242_d))).count();
            if (fluidFaces <= 0L) continue;
            if (fluidFaces < (long)part.field_178240_c.size()) {
                TConstruct.LOG.warn("Mixed fluid and non-fluid elements in model {}, may cause unexpected results", (Object)modelLocation);
            }
            fluidParts.set(i);
        }
        return new Baked(baked, elements, owner, transform, fluidTextures, fluidParts);
    }

    public FluidTextureModel(SimpleBlockModel model, Set<String> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel> {
        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public FluidTextureModel read(JsonDeserializationContext context, JsonObject json) {
            SimpleBlockModel model = SimpleBlockModel.deserialize((JsonDeserializationContext)context, (JsonObject)json);
            ImmutableSet fluids = ImmutableSet.copyOf((Collection)JsonHelper.parseList((JsonObject)json, (String)"fluids", JSONUtils::func_151206_a));
            return new FluidTextureModel(model, (Set<String>)fluids);
        }
    }

    private static class Baked
    extends DynamicBakedWrapper<IBakedModel> {
        private final Map<FluidStack, IBakedModel> cache = new ConcurrentHashMap<FluidStack, IBakedModel>();
        private final List<BlockPart> elements;
        private final IModelConfiguration owner;
        private final IModelTransform transform;
        private final Set<String> fluids;
        private final BitSet fluidParts;

        protected Baked(IBakedModel originalModel, List<BlockPart> elements, IModelConfiguration owner, IModelTransform transform, Set<String> fluids, BitSet fluidParts) {
            super(originalModel);
            this.elements = elements;
            this.owner = owner;
            this.transform = transform;
            this.fluids = fluids;
            this.fluidParts = fluidParts;
        }

        private IBakedModel getRetexturedModel(FluidStack fluid) {
            Function spriteGetter = ModelLoader.defaultTextureGetter();
            TextureAtlasSprite particle = (TextureAtlasSprite)spriteGetter.apply(this.owner.resolveTexture("particle"));
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.owner, ItemOverrideList.field_188022_a).func_177646_a(particle);
            FluidAttributes attributes = fluid.getFluid().getAttributes();
            int color = attributes.getColor(fluid);
            int luminosity = attributes.getLuminosity(fluid);
            RetexturedModel.RetexturedConfiguration textured = new RetexturedModel.RetexturedConfiguration(this.owner, this.fluids, attributes.getStillTexture(fluid));
            int size = this.elements.size();
            for (int i = 0; i < size; ++i) {
                BlockPart element = this.elements.get(i);
                if (this.fluidParts.get(i)) {
                    ColoredBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)textured, (BlockPart)element, (int)color, (int)luminosity, (IModelTransform)this.transform, (Function)spriteGetter, (ResourceLocation)TankModel.BAKE_LOCATION);
                    continue;
                }
                SimpleBlockModel.bakePart((SimpleBakedModel.Builder)builder, (IModelConfiguration)this.owner, (BlockPart)element, (IModelTransform)this.transform, (Function)spriteGetter, (ResourceLocation)TankModel.BAKE_LOCATION);
            }
            return builder.func_177645_b();
        }

        private IBakedModel getCachedModel(FluidStack fluid) {
            return this.cache.computeIfAbsent(fluid, this::getRetexturedModel);
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, Random random, IModelData data) {
            FluidStack fluid = (FluidStack)data.getData(IDisplayFluidListener.PROPERTY);
            if (fluid != null && !fluid.isEmpty()) {
                return this.getCachedModel(fluid).getQuads(state, direction, random, data);
            }
            return this.originalModel.getQuads(state, direction, random, data);
        }
    }
}

