/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoJson;
import slimeknights.tconstruct.library.data.IEarlySafeManagerReloadListener;
import slimeknights.tconstruct.library.data.ResourceLocationSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialRenderInfoLoader
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(MaterialRenderInfoLoader.class);
    public static final MaterialRenderInfoLoader INSTANCE = new MaterialRenderInfoLoader();
    public static final String FOLDER = "models/tool_materials";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(MaterialStatsId.class, new ResourceLocationSerializer<MaterialStatsId>(MaterialStatsId::new, "tconstruct")).registerTypeHierarchyAdapter(ISpriteTransformer.class, ISpriteTransformer.SERIALIZER).registerTypeHierarchyAdapter(IColorMapping.class, IColorMapping.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private Map<MaterialId, MaterialRenderInfo> renderInfos = ImmutableMap.of();

    public static void addResourceListener(IReloadableResourceManager manager) {
        manager.func_219534_a((IFutureReloadListener)INSTANCE);
    }

    private MaterialRenderInfoLoader() {
    }

    public Collection<MaterialRenderInfo> getAllRenderInfos() {
        return this.renderInfos.values();
    }

    public Optional<MaterialRenderInfo> getRenderInfo(MaterialId materialId) {
        return Optional.ofNullable(this.renderInfos.get((Object)materialId));
    }

    @Override
    public void onReloadSafe(IResourceManager manager) {
        int trim = FOLDER.length() + 1;
        HashMap<MaterialId, MaterialRenderInfo> map = new HashMap<MaterialId, MaterialRenderInfo>();
        for (ResourceLocation location : manager.func_199003_a(FOLDER, loc -> loc.endsWith(".json"))) {
            String path = location.func_110623_a();
            MaterialId id = new MaterialId(location.func_110624_b(), path.substring(trim, path.length() - 5));
            try {
                IResource iresource = manager.func_199002_a(location);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            MaterialRenderInfoJson json = (MaterialRenderInfoJson)GSON.fromJson((Reader)reader, MaterialRenderInfoJson.class);
                            if (json == null) {
                                log.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)location);
                                continue;
                            }
                            MaterialRenderInfo old = map.put(id, this.loadRenderInfo(id, json));
                            if (old == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + (Object)((Object)id));
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                log.error("Couldn't parse data file {} from {}", (Object)id, (Object)location, (Object)jsonparseexception);
            }
        }
        this.renderInfos = map;
        log.debug("Loaded material render infos: {}", (Object)Util.toIndentedStringList(map.keySet()));
        log.info("{} material render infos loaded", (Object)map.size());
    }

    private MaterialRenderInfo loadRenderInfo(ResourceLocation loc, MaterialRenderInfoJson json) {
        String[] fallback;
        int color = -1;
        if (json.getColor() != null) {
            color = JsonHelper.parseColor((String)json.getColor());
        }
        MaterialId id = new MaterialId(loc);
        ResourceLocation texture = null;
        if (!json.isSkipUniqueTexture() && (texture = json.getTexture()) == null) {
            texture = id;
        }
        if ((fallback = json.getFallbacks()) == null) {
            fallback = new String[]{};
        }
        return new MaterialRenderInfo(id, texture, fallback, color, json.getLuminosity());
    }
}

