/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.spritetransformer;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.utils.Util;

public class GreyToColorMapping
implements IColorMapping {
    public static final ResourceLocation NAME = TConstruct.getResource("grey_to_color");
    public static final Deserializer DESERIALIZER = new Deserializer();
    private final List<ColorMapping> mappings;
    private final Integer[] recolorCache = new Integer[256];
    private static final Interpolate<ColorMapping, Integer> INTERPOLATE_COLORS = (first, second, grey) -> {
        if (first == null) {
            assert (second != null);
            return second.getColor();
        }
        if (second == null) {
            return first.getColor();
        }
        return GreyToColorMapping.interpolateColors(first.getColor(), first.getGrey(), second.getColor(), second.getGrey(), grey);
    };
    private static final ToIntFunction<ColorMapping> GET_GREY = ColorMapping::getGrey;

    public int getColorForGrey(int grey) {
        if (this.recolorCache[grey] == null) {
            int calculated = GreyToColorMapping.getNearestByGrey(this.mappings, GET_GREY, grey, INTERPOLATE_COLORS);
            this.recolorCache[grey] = calculated;
        }
        return this.recolorCache[grey];
    }

    @Override
    public int mapColor(int color) {
        if (NativeImage.func_227786_a_((int)color) == 0) {
            return 0;
        }
        int grey = GreyToColorMapping.getGrey(color);
        return GreyToColorMapping.scaleColor(color, this.getColorForGrey(grey), grey);
    }

    @Override
    public JsonObject serialize(JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        object.addProperty("type", NAME.toString());
        JsonArray colors = new JsonArray();
        for (ColorMapping mapping : this.mappings) {
            JsonObject pair = new JsonObject();
            pair.addProperty("grey", (Number)mapping.grey);
            pair.addProperty("color", String.format("%08X", Util.translateColorBGR(mapping.color)));
            colors.add((JsonElement)pair);
        }
        object.add("palette", (JsonElement)colors);
        return object;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFromBlack() {
        return GreyToColorMapping.builder().addABGR(0, -16777216);
    }

    public static int interpolate(int a, int b, int x, int divisor) {
        return a + (b - a) * x / divisor;
    }

    public static int interpolateColors(int colorBefore, int greyBefore, int colorAfter, int greyAfter, int grey) {
        int diff = grey - greyBefore;
        int divisor = greyAfter - greyBefore;
        int alpha = GreyToColorMapping.interpolate(NativeImage.func_227786_a_((int)colorBefore), NativeImage.func_227786_a_((int)colorAfter), diff, divisor);
        int red = GreyToColorMapping.interpolate(NativeImage.func_227791_b_((int)colorBefore), NativeImage.func_227791_b_((int)colorAfter), diff, divisor);
        int green = GreyToColorMapping.interpolate(NativeImage.func_227793_c_((int)colorBefore), NativeImage.func_227793_c_((int)colorAfter), diff, divisor);
        int blue = GreyToColorMapping.interpolate(NativeImage.func_227795_d_((int)colorBefore), NativeImage.func_227795_d_((int)colorAfter), diff, divisor);
        return NativeImage.func_227787_a_((int)alpha, (int)blue, (int)green, (int)red);
    }

    public static int getGrey(int color) {
        return Math.max(NativeImage.func_227791_b_((int)color), Math.max(NativeImage.func_227793_c_((int)color), NativeImage.func_227795_d_((int)color)));
    }

    public static int scaleColor(int original, int newColor, int grey) {
        int blue;
        int green;
        int red;
        int alpha = NativeImage.func_227786_a_((int)original);
        if (alpha < 255) {
            newColor = newColor & 0xFFFFFF | alpha * NativeImage.func_227786_a_((int)newColor) / 255 << 24;
        }
        if ((red = NativeImage.func_227791_b_((int)original)) < grey) {
            newColor = newColor & 0xFFFFFF00 | (newColor & 0xFF) * red / grey & 0xFF;
        }
        if ((green = NativeImage.func_227793_c_((int)original)) < grey) {
            newColor = newColor & 0xFFFF00FF | (newColor & 0xFF00) * green / grey & 0xFF00;
        }
        if ((blue = NativeImage.func_227795_d_((int)original)) < grey) {
            newColor = newColor & 0xFF00FFFF | (newColor & 0xFF0000) * blue / grey & 0xFF0000;
        }
        return newColor;
    }

    public static <T, R> R getNearestByGrey(List<T> list, ToIntFunction<T> greyMap, int grey, Interpolate<T, R> interpolate) {
        int newGrey;
        int size = list.size();
        T first = list.get(0);
        if (size == 1 || grey <= greyMap.applyAsInt(first)) {
            return interpolate.interpolate(null, first, grey);
        }
        T second = list.get(1);
        for (int i = 1; i < size && grey >= (newGrey = greyMap.applyAsInt(second)); ++i) {
            if (grey == newGrey) {
                return interpolate.interpolate(first, second, grey);
            }
            first = second;
            second = list.get(i);
        }
        if (grey > greyMap.applyAsInt(second)) {
            return interpolate.interpolate(second, null, grey);
        }
        return interpolate.interpolate(first, second, grey);
    }

    protected GreyToColorMapping(List<ColorMapping> mappings) {
        this.mappings = mappings;
    }

    public static class Builder {
        private final ImmutableList.Builder<ColorMapping> builder = ImmutableList.builder();
        private int lastGrey = -1;

        private void checkGrey(int grey) {
            if (grey < 0 || grey > 255) {
                throw new IllegalArgumentException("Invalid grey value, must be between 0 and 255, inclusive");
            }
            if (grey <= this.lastGrey) {
                throw new IllegalArgumentException("Grey value must be greater than the previous value");
            }
            this.lastGrey = grey;
        }

        public Builder addABGR(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new ColorMapping(grey, color));
            return this;
        }

        public Builder addARGB(int grey, int color) {
            this.checkGrey(grey);
            this.builder.add((Object)new ColorMapping(grey, Util.translateColorBGR(color)));
            return this;
        }

        public GreyToColorMapping build() {
            ImmutableList list = this.builder.build();
            if (list.size() < 2) {
                throw new IllegalStateException("Too few colors in palette, must have at least 2");
            }
            return new GreyToColorMapping((List<ColorMapping>)list);
        }
    }

    @FunctionalInterface
    public static interface Interpolate<T, R> {
        public R interpolate(@Nullable T var1, @Nullable T var2, int var3);
    }

    private static class ColorMapping {
        private final int grey;
        private final int color;

        public ColorMapping(int grey, int color) {
            this.grey = grey;
            this.color = color;
        }

        public int getGrey() {
            return this.grey;
        }

        public int getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColorMapping)) {
                return false;
            }
            ColorMapping other = (ColorMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGrey() != other.getGrey()) {
                return false;
            }
            return this.getColor() == other.getColor();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColorMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGrey();
            result = result * 59 + this.getColor();
            return result;
        }

        public String toString() {
            return "GreyToColorMapping.ColorMapping(grey=" + this.getGrey() + ", color=" + this.getColor() + ")";
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<GreyToColorMapping> {
        protected Deserializer() {
        }

        public GreyToColorMapping deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JsonArray palette = JSONUtils.func_151214_t((JsonObject)object, (String)"palette");
            Builder paletteBuilder = GreyToColorMapping.builder();
            for (int i = 0; i < palette.size(); ++i) {
                JsonObject palettePair = JSONUtils.func_151210_l((JsonElement)palette.get(i), (String)("palette[" + i + ']'));
                int grey = JSONUtils.func_151203_m((JsonObject)palettePair, (String)"grey");
                int color = JsonHelper.parseColor((String)JSONUtils.func_151200_h((JsonObject)palettePair, (String)"color"));
                if (i == 0 && grey != 0) {
                    paletteBuilder.addABGR(0, -16777216);
                }
                paletteBuilder.addARGB(grey, color);
            }
            return paletteBuilder.build();
        }
    }
}

