/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemDurabilityTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.advancements.criterion.PlayerEntityInteractionTrigger;
import net.minecraft.advancements.criterion.PositionTrigger;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.CountRequirementsStrategy;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.gadgets.TinkerGadgets;
import slimeknights.tconstruct.library.data.GenericDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.tools.ToolPredicate;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.shared.inventory.BlockContainerOpenedTrigger;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.SearedLanternBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.item.TankItem;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.item.ArmorSlotType;
import slimeknights.tconstruct.tools.item.broad.VeinHammerTool;
import slimeknights.tconstruct.tools.item.small.HarvestTool;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

public class AdvancementsProvider
extends GenericDataProvider {
    protected Consumer<Advancement> advancementConsumer;

    public AdvancementsProvider(DataGenerator generatorIn) {
        super(generatorIn, "advancements");
    }

    public String func_200397_b() {
        return "Tinkers' Construct Advancements";
    }

    protected void generate() {
        Advancement materialsAndYou = this.builder((IItemProvider)TinkerCommons.materialsAndYou, this.resource("tools/materials_and_you"), this.resource("textures/gui/advancement_background.png"), FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.materialsAndYou)));
        Advancement partBuilder = this.builder((IItemProvider)TinkerTables.partBuilder, this.resource("tools/part_builder"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_block", this.hasItem((IItemProvider)TinkerTables.partBuilder)));
        this.builder(((ToolPartItem)TinkerToolParts.pickaxeHead.get()).withMaterialForDisplay(MaterialIds.wood), this.resource("tools/make_part"), partBuilder, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_part", this.hasTag((ITag<Item>)TinkerTags.Items.TOOL_PARTS)));
        Advancement tinkerStation = this.builder((IItemProvider)TinkerTables.tinkerStation, this.resource("tools/tinker_station"), partBuilder, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_block", this.hasItem((IItemProvider)TinkerTables.tinkerStation)));
        Advancement tinkerTool = this.builder(((HarvestTool)TinkerTools.pickaxe.get()).getRenderTool(), this.resource("tools/tinker_tool"), tinkerStation, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_tool", this.hasTag((ITag<Item>)TinkerTags.Items.MULTIPART_TOOL)));
        this.builder((IItemProvider)TinkerMaterials.manyullyn.getIngot(), this.resource("tools/material_master"), tinkerTool, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<MaterialId> with = id -> builder.func_200275_a(id.func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ToolPredicate.builder().withMaterial((MaterialId)((Object)((Object)id))).build()}));
            with.accept(MaterialIds.wood);
            with.accept(MaterialIds.flint);
            with.accept(MaterialIds.stone);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.leather);
            with.accept(MaterialIds.string);
            with.accept(MaterialIds.vine);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.searedStone);
            with.accept(MaterialIds.scorchedStone);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.slimewood);
            with.accept(MaterialIds.chain);
            with.accept(MaterialIds.skyslimeVine);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.slimesteel);
            with.accept(MaterialIds.nahuatl);
            with.accept(MaterialIds.tinkersBronze);
            with.accept(MaterialIds.pigIron);
            with.accept(MaterialIds.cobalt);
            with.accept(MaterialIds.darkthread);
            with.accept(MaterialIds.manyullyn);
            with.accept(MaterialIds.hepatizon);
            with.accept(MaterialIds.queensSlime);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.ancientHide);
            with.accept(MaterialIds.enderslimeVine);
        });
        this.builder(((ModifiableArmorItem)TinkerTools.travelersGear.get((Enum)ArmorSlotType.HELMET)).getRenderTool(), this.resource("tools/travelers_gear"), tinkerStation, FrameType.TASK, (Advancement.Builder builder) -> TinkerTools.travelersGear.forEach((type, armor) -> builder.func_200275_a("crafted_" + type.func_176610_l(), this.hasItem((IItemProvider)armor))));
        this.builder(((HarvestTool)TinkerTools.pickaxe.get()).getRenderTool(), this.resource("tools/tool_smith"), tinkerTool, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<Item> with = item -> builder.func_200275_a(Objects.requireNonNull(item.getRegistryName()).func_110623_a(), this.hasItem((IItemProvider)item));
            with.accept((Item)TinkerTools.pickaxe.get());
            with.accept((Item)TinkerTools.mattock.get());
            with.accept((Item)TinkerTools.handAxe.get());
            with.accept((Item)TinkerTools.kama.get());
            with.accept((Item)TinkerTools.dagger.get());
            with.accept((Item)TinkerTools.sword.get());
        });
        Advancement modified = this.builder((IItemProvider)Items.field_151137_ax, this.resource("tools/modified"), tinkerTool, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_tool", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ToolPredicate.builder().hasUpgrades(true).build()})));
        this.builder((IItemProvider)Items.field_151099_bA, this.resource("tools/upgrade_slots"), modified, FrameType.CHALLENGE, (Advancement.Builder builder) -> builder.func_200275_a("has_modified", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ToolPredicate.builder().upgrades(ModifierMatch.list(5, ModifierMatch.entry((Modifier)TinkerModifiers.writable.get()), ModifierMatch.entry((Modifier)TinkerModifiers.recapitated.get()), ModifierMatch.entry((Modifier)TinkerModifiers.harmonious.get()), ModifierMatch.entry((Modifier)TinkerModifiers.resurrected.get()), ModifierMatch.entry((Modifier)TinkerModifiers.gilded.get()))).build()})));
        Advancement punySmelting = this.builder((IItemProvider)TinkerCommons.punySmelting, this.resource("smeltery/puny_smelting"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.punySmelting)));
        Advancement melter = this.builder((IItemProvider)TinkerSmeltery.searedMelter, this.resource("smeltery/melter"), punySmelting, FrameType.TASK, (Advancement.Builder builder) -> {
            Consumer<Block> with = block -> builder.func_200275_a(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)block));
            with.accept((Block)TinkerSmeltery.searedMelter.get());
            with.accept((Block)TinkerSmeltery.searedTable.get());
            with.accept((Block)TinkerSmeltery.searedBasin.get());
            with.accept((Block)TinkerSmeltery.searedFaucet.get());
            with.accept((Block)TinkerSmeltery.searedHeater.get());
            TinkerSmeltery.searedTank.forEach(with);
            builder.func_200270_a((IRequirementsStrategy)new CountRequirementsStrategy(1, 1, 1, 1, 1 + SearedTankBlock.TankType.values().length));
        });
        this.builder((IItemProvider)TinkerSmeltery.toolHandleCast.getSand(), this.resource("smeltery/sand_casting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_cast", this.hasTag((ITag<Item>)TinkerSmeltery.blankCast.getSingleUseTag())));
        Advancement goldCasting = this.builder((IItemProvider)TinkerSmeltery.pickaxeHeadCast, this.resource("smeltery/gold_casting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_cast", this.hasTag((ITag<Item>)TinkerTags.Items.GOLD_CASTS)));
        this.builder((IItemProvider)TinkerSmeltery.hammerHeadCast, this.resource("smeltery/cast_collector"), goldCasting, FrameType.GOAL, (Advancement.Builder builder) -> {
            Consumer<CastItemObject> with = cast -> builder.func_200275_a(cast.getName().func_110623_a(), this.hasItem((IItemProvider)cast.get()));
            with.accept(TinkerSmeltery.blankCast);
            with.accept(TinkerSmeltery.ingotCast);
            with.accept(TinkerSmeltery.nuggetCast);
            with.accept(TinkerSmeltery.gemCast);
            with.accept(TinkerSmeltery.rodCast);
            with.accept(TinkerSmeltery.repairKitCast);
            with.accept(TinkerSmeltery.pickaxeHeadCast);
            with.accept(TinkerSmeltery.smallAxeHeadCast);
            with.accept(TinkerSmeltery.smallBladeCast);
            with.accept(TinkerSmeltery.hammerHeadCast);
            with.accept(TinkerSmeltery.broadBladeCast);
            with.accept(TinkerSmeltery.broadAxeHeadCast);
            with.accept(TinkerSmeltery.toolBindingCast);
            with.accept(TinkerSmeltery.largePlateCast);
            with.accept(TinkerSmeltery.toolHandleCast);
            with.accept(TinkerSmeltery.toughHandleCast);
        });
        Advancement mightySmelting = this.builder((IItemProvider)TinkerCommons.mightySmelting, this.resource("smeltery/mighty_smelting"), melter, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.mightySmelting)));
        Advancement smeltery = this.builder((IItemProvider)TinkerSmeltery.smelteryController, this.resource("smeltery/structure"), mightySmelting, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("open_smeltery", (ICriterionInstance)BlockContainerOpenedTrigger.Instance.container((TileEntityType)TinkerSmeltery.smeltery.get())));
        Advancement anvil = this.builder((IItemProvider)TinkerTables.tinkersAnvil, this.resource("smeltery/tinkers_anvil"), smeltery, FrameType.GOAL, (Advancement.Builder builder) -> {
            builder.func_200275_a("crafted_overworld", this.hasItem((IItemProvider)TinkerTables.tinkersAnvil));
            builder.func_200275_a("crafted_nether", this.hasItem((IItemProvider)TinkerTables.scorchedAnvil));
            builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
        });
        this.builder(((VeinHammerTool)TinkerTools.veinHammer.get()).getRenderTool(), this.resource("smeltery/tool_forge"), anvil, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<Item> with = item -> builder.func_200275_a(Objects.requireNonNull(item.getRegistryName()).func_110623_a(), this.hasItem((IItemProvider)item));
            with.accept((Item)TinkerTools.sledgeHammer.get());
            with.accept((Item)TinkerTools.veinHammer.get());
            with.accept((Item)TinkerTools.excavator.get());
            with.accept((Item)TinkerTools.broadAxe.get());
            with.accept((Item)TinkerTools.scythe.get());
            with.accept((Item)TinkerTools.cleaver.get());
        });
        this.builder((IItemProvider)TinkerModifiers.silkyCloth, this.resource("smeltery/abilities"), anvil, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<Supplier> with = modifier -> builder.func_200275_a(((Modifier)modifier.get()).getId().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ToolPredicate.builder().modifiers(ModifierMatch.entry((Modifier)modifier.get())).build()}));
            with.accept((Supplier)TinkerModifiers.gilded);
            with.accept((Supplier)TinkerModifiers.luck);
            with.accept((Supplier)TinkerModifiers.reach);
            with.accept((Supplier)TinkerModifiers.unbreakable);
            with.accept((Supplier)TinkerModifiers.aquaAffinity);
            with.accept((Supplier)TinkerModifiers.bouncy);
            with.accept((Supplier)TinkerModifiers.doubleJump);
            with.accept((Supplier)TinkerModifiers.flamewake);
            with.accept((Supplier)TinkerModifiers.frostWalker);
            with.accept((Supplier)TinkerModifiers.looting);
            with.accept((Supplier)TinkerModifiers.pathMaker);
            with.accept((Supplier)TinkerModifiers.plowing);
            with.accept((Supplier)TinkerModifiers.pockets);
            with.accept((Supplier)TinkerModifiers.shieldStrap);
            with.accept((Supplier)TinkerModifiers.slurping);
            with.accept((Supplier)TinkerModifiers.snowdrift);
            with.accept((Supplier)TinkerModifiers.strength);
            with.accept((Supplier)TinkerModifiers.toolBelt);
            with.accept((Supplier)TinkerModifiers.unarmed);
            with.accept((Supplier)TinkerModifiers.zoom);
            with.accept((Supplier)TinkerModifiers.autosmelt);
            with.accept((Supplier)TinkerModifiers.exchanging);
            with.accept((Supplier)TinkerModifiers.expanded);
            with.accept((Supplier)TinkerModifiers.silky);
            with.accept((Supplier)TinkerModifiers.bucketing);
            with.accept((Supplier)TinkerModifiers.firestarter);
            with.accept((Supplier)TinkerModifiers.glowing);
            with.accept((Supplier)TinkerModifiers.pathing);
            with.accept((Supplier)TinkerModifiers.stripping);
            with.accept((Supplier)TinkerModifiers.tilling);
            with.accept((Supplier)TinkerModifiers.dualWielding);
            with.accept((Supplier)TinkerModifiers.melting);
            with.accept((Supplier)TinkerModifiers.spilling);
        });
        Advancement fantasticFoundry = this.builder((IItemProvider)TinkerCommons.fantasticFoundry, this.resource("foundry/fantastic_foundry"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.fantasticFoundry)));
        this.builder((IItemProvider)TinkerCommons.encyclopedia, this.resource("foundry/encyclopedia"), fantasticFoundry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.encyclopedia)));
        Advancement alloyer = this.builder((IItemProvider)TinkerSmeltery.scorchedAlloyer, this.resource("foundry/alloyer"), fantasticFoundry, FrameType.TASK, (Advancement.Builder builder) -> {
            Consumer<Block> with = block -> builder.func_200275_a(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)block));
            with.accept((Block)TinkerSmeltery.scorchedAlloyer.get());
            with.accept((Block)TinkerSmeltery.scorchedFaucet.get());
            with.accept((Block)TinkerSmeltery.scorchedTable.get());
            with.accept((Block)TinkerSmeltery.scorchedBasin.get());
            for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
                with.accept((Block)TinkerSmeltery.scorchedTank.get((Enum)type));
            }
            builder.func_200270_a((IRequirementsStrategy)new CountRequirementsStrategy(1, 1, 1, 1, 2, 2));
        });
        Advancement foundry = this.builder((IItemProvider)TinkerSmeltery.foundryController, this.resource("foundry/structure"), alloyer, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("open_foundry", (ICriterionInstance)BlockContainerOpenedTrigger.Instance.container((TileEntityType)TinkerSmeltery.foundry.get())));
        Advancement blazingBlood = this.builder(TankItem.setTank(new ItemStack((IItemProvider)TinkerSmeltery.scorchedTank.get((Enum)SearedTankBlock.TankType.FUEL_GAUGE)), AdvancementsProvider.getTankWith((Fluid)TinkerFluids.blazingBlood.get(), SearedTankBlock.TankType.FUEL_GAUGE.getCapacity())), this.resource("foundry/blaze"), foundry, FrameType.GOAL, (Advancement.Builder builder) -> {
            Consumer<SearedTankBlock> with = block -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("tank", (INBT)AdvancementsProvider.getTankWith((Fluid)TinkerFluids.blazingBlood.get(), block.getCapacity()).writeToNBT(new CompoundNBT()));
                builder.func_200275_a(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)block).func_218002_a(nbt).func_200310_b()}));
                builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
            };
            TinkerSmeltery.searedTank.forEach(with);
            TinkerSmeltery.scorchedTank.forEach(with);
        });
        this.builder(((ModifiableArmorItem)TinkerTools.plateArmor.get((Enum)ArmorSlotType.CHESTPLATE)).getRenderTool(), this.resource("foundry/plate_armor"), blazingBlood, FrameType.GOAL, (Advancement.Builder builder) -> TinkerTools.plateArmor.forEach((type, armor) -> builder.func_200275_a("crafted_" + type.func_176610_l(), this.hasItem((IItemProvider)armor))));
        this.builder(TankItem.setTank(new ItemStack(TinkerSmeltery.scorchedLantern), AdvancementsProvider.getTankWith((Fluid)TinkerFluids.moltenManyullyn.get(), ((SearedLanternBlock)TinkerSmeltery.scorchedLantern.get()).getCapacity())), this.resource("foundry/manyullyn_lanterns"), foundry, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Consumer<SearedLanternBlock> with = block -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("tank", (INBT)AdvancementsProvider.getTankWith((Fluid)TinkerFluids.moltenManyullyn.get(), block.getCapacity()).writeToNBT(new CompoundNBT()));
                builder.func_200275_a(Objects.requireNonNull(block.getRegistryName()).func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, block.func_199767_j(), MinMaxBounds.IntBound.func_211340_b((int)64), MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, new NBTPredicate(nbt))}));
                builder.func_200270_a(IRequirementsStrategy.field_223215_b_);
            };
            with.accept((SearedLanternBlock)TinkerSmeltery.searedLantern.get());
            with.accept((SearedLanternBlock)TinkerSmeltery.scorchedLantern.get());
        });
        Advancement tinkersGadgetry = this.builder((IItemProvider)TinkerCommons.tinkersGadgetry, this.resource("world/tinkers_gadgetry"), materialsAndYou, FrameType.TASK, (Advancement.Builder builder) -> builder.func_200275_a("crafted_book", this.hasItem((IItemProvider)TinkerCommons.tinkersGadgetry)));
        this.builder((IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeType.EARTH), this.resource("world/earth_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("found_island", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)((Structure)TinkerStructures.earthSlimeIsland.get())))));
        this.builder((IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeType.SKY), this.resource("world/sky_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("found_island", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)((Structure)TinkerStructures.skySlimeIsland.get())))));
        this.builder((IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeType.BLOOD), this.resource("world/blood_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("found_island", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)((Structure)TinkerStructures.bloodSlimeIsland.get())))));
        Advancement enderslimeIsland = this.builder((IItemProvider)TinkerWorld.slimeSapling.get((Enum)SlimeType.ENDER), this.resource("world/ender_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("found_island", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)((Structure)TinkerStructures.endSlimeIsland.get())))));
        this.builder((IItemProvider)Items.field_151119_aD, this.resource("world/clay_island"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("found_island", (ICriterionInstance)PositionTrigger.Instance.func_203932_a((LocationPredicate)LocationPredicate.func_218020_a((Structure)((Structure)TinkerStructures.clayIsland.get())))));
        Advancement slimes = this.builder((IItemProvider)TinkerCommons.slimeball.get((Enum)SlimeType.ICHOR), this.resource("world/slime_collector"), tinkersGadgetry, FrameType.TASK, (Advancement.Builder builder) -> {
            for (SlimeType type : SlimeType.values()) {
                builder.func_200275_a(type.func_176610_l(), this.hasTag((ITag<Item>)type.getSlimeballTag()));
            }
            builder.func_200275_a("magma_cream", this.hasItem((IItemProvider)Items.field_151064_bs));
        });
        this.builder((IItemProvider)TinkerGadgets.slimeSling.get((Enum)SlimeType.ENDER), this.resource("world/slime_sling"), slimes, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            JsonObject boundJSON = new JsonObject();
            boundJSON.addProperty("max", (Number)150);
            MinMaxBounds.IntBound mojangDeletedTheMaxMethods = MinMaxBounds.IntBound.func_211344_a((JsonElement)boundJSON);
            TinkerGadgets.slimeSling.forEach((type, sling) -> builder.func_200275_a(type.func_176610_l(), (ICriterionInstance)ItemDurabilityTrigger.Instance.func_234816_a_((EntityPredicate.AndPredicate)EntityPredicate.AndPredicate.field_234582_a_, (ItemPredicate)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)sling).func_200310_b(), (MinMaxBounds.IntBound)mojangDeletedTheMaxMethods)));
        });
        this.builder((IItemProvider)TinkerGadgets.piggyBackpack, this.resource("world/piggybackpack"), tinkersGadgetry, FrameType.GOAL, (Advancement.Builder builder) -> builder.func_200275_a("used_pack", (ICriterionInstance)PlayerEntityInteractionTrigger.Instance.func_241480_a_((EntityPredicate.AndPredicate)EntityPredicate.AndPredicate.field_234582_a_, (ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a(TinkerGadgets.piggyBackpack), (EntityPredicate.AndPredicate)EntityPredicate.AndPredicate.func_234585_a_((EntityPredicate)EntityPredicate.Builder.func_203996_a().func_203998_a(EntityType.field_200784_X).func_204000_b()))));
        Advancement slimesuit = this.builder(((ModifiableArmorItem)TinkerTools.slimesuit.get((Enum)ArmorSlotType.CHESTPLATE)).getRenderTool(), this.resource("world/slimesuit"), enderslimeIsland, FrameType.GOAL, (Advancement.Builder builder) -> TinkerTools.slimesuit.forEach((type, armor) -> builder.func_200275_a("crafted_" + type.func_176610_l(), this.hasItem((IItemProvider)armor))));
        this.builder(new MaterialIdNBT(Collections.singletonList(MaterialIds.gunpowder)).updateStack(new ItemStack((IItemProvider)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET))), this.resource("world/slimeskull"), slimesuit, FrameType.CHALLENGE, (Advancement.Builder builder) -> {
            Item helmet = (Item)TinkerTools.slimesuit.get((Enum)ArmorSlotType.HELMET);
            Consumer<MaterialId> with = mat -> builder.func_200275_a(mat.func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ToolPredicate.builder(helmet).withMaterial((MaterialId)((Object)((Object)mat))).build()}));
            with.accept(MaterialIds.gunpowder);
            with.accept(MaterialIds.bone);
            with.accept(MaterialIds.necroticBone);
            with.accept(MaterialIds.rottenFlesh);
            with.accept(MaterialIds.enderPearl);
            with.accept(MaterialIds.bloodbone);
            with.accept(MaterialIds.spider);
            with.accept(MaterialIds.venom);
            with.accept(MaterialIds.iron);
            with.accept(MaterialIds.copper);
            with.accept(MaterialIds.blazingBone);
            with.accept(MaterialIds.gold);
            with.accept(MaterialIds.roseGold);
            with.accept(MaterialIds.pigIron);
        });
    }

    private static FluidTank getTankWith(Fluid fluid, int capacity) {
        FluidTank tank = new FluidTank(capacity);
        tank.fill(new FluidStack(fluid, capacity), IFluidHandler.FluidAction.EXECUTE);
        return tank;
    }

    private ICriterionInstance hasTag(ITag<Item> tag) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(tag).func_200310_b()});
    }

    private ICriterionInstance hasItem(IItemProvider item) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200308_a(item).func_200310_b()});
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.advancementConsumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            this.saveThing(cache, advancement.func_192067_g(), advancement.func_192075_a().func_200273_b());
        };
        this.generate();
    }

    protected ResourceLocation resource(String name) {
        return TConstruct.getResource(name);
    }

    protected Advancement builder(IItemProvider display, ResourceLocation name, Advancement parent, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(new ItemStack(display), name, parent, frame, consumer);
    }

    protected Advancement builder(ItemStack display, ResourceLocation name, Advancement parent, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(display, name, (ResourceLocation)null, frame, (Advancement.Builder builder) -> {
            builder.func_203905_a(parent);
            consumer.accept((Advancement.Builder)builder);
        });
    }

    protected Advancement builder(IItemProvider display, ResourceLocation name, @Nullable ResourceLocation background, FrameType frame, Consumer<Advancement.Builder> consumer) {
        return this.builder(new ItemStack(display), name, background, frame, consumer);
    }

    private static String makeTranslationKey(ResourceLocation advancement) {
        return "advancements." + advancement.func_110624_b() + "." + advancement.func_110623_a().replace('/', '.');
    }

    protected Advancement builder(ItemStack display, ResourceLocation name, @Nullable ResourceLocation background, FrameType frame, Consumer<Advancement.Builder> consumer) {
        Advancement.Builder builder = Advancement.Builder.func_200278_a().func_215092_a(display, (ITextComponent)new TranslationTextComponent(AdvancementsProvider.makeTranslationKey(name) + ".title"), (ITextComponent)new TranslationTextComponent(AdvancementsProvider.makeTranslationKey(name) + ".description"), background, frame, true, frame != FrameType.TASK, false);
        consumer.accept(builder);
        return builder.func_203904_a(this.advancementConsumer, name.toString());
    }
}

