/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.structures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.world.structures.ConfiguredFeatures;
import net.mehvahdjukaar.supplementaries.world.structures.FeaturesHandler;
import net.mehvahdjukaar.supplementaries.world.structures.WaySignStructure;
import net.mehvahdjukaar.supplementaries.world.structures.processors.SignDataProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StructureRegistry {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"supplementaries");
    public static final RegistryObject<Structure<NoFeatureConfig>> WAY_SIGN = STRUCTURES.register("way_sign", () -> new WaySignStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static Method GETCODEC_METHOD;

    public static void init(IEventBus bus) {
        STRUCTURES.register(bus);
        FeaturesHandler.FEATURES.register(bus);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, StructureRegistry::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, StructureRegistry::addStructureToBiome);
    }

    public static void setup() {
        StructureRegistry.setupStructures();
        ConfiguredFeatures.register();
        SignDataProcessor.register();
    }

    public static void addStructureToBiome(BiomeLoadingEvent event) {
        if (BiomeDictionary.hasType((RegistryKey)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || (Integer)ServerConfigs.spawn.ROAD_SIGN_DISTANCE_MIN.get() == 1001) {
            return;
        }
        event.getGeneration().getStructures().add(() -> ConfiguredFeatures.CONFIGURED_WAY_SIGN);
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            HashMap<IForgeRegistryEntry, Object> tempMap;
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().getRegistryName() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().field_186029_c instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            boolean isVillageDimension = false;
            try {
                BiomeProvider provider = serverWorld.func_72863_F().field_186029_c.func_202090_b();
                List biomes = provider.func_235203_c_();
                if (biomes.contains(null)) {
                    Supplementaries.LOGGER.throwing((Throwable)new Exception("something went wrong: found a null biome in the biome provider"));
                }
                isVillageDimension = provider.func_205004_a(Structure.field_236381_q_);
            }
            catch (Exception ignored) {
                Supplementaries.LOGGER.throwing((Throwable)new Exception("failed to add structure to biomes: something went wrong, might be some other mod bug"));
            }
            if (isVillageDimension && serverWorld.func_230315_m_().func_236043_f_() && (Integer)ServerConfigs.spawn.ROAD_SIGN_DISTANCE_MIN.get() != 1001) {
                tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.putIfAbsent(WAY_SIGN.get(), DimensionStructuresSettings.field_236191_b_.get((Object)WAY_SIGN.get()));
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            } else {
                tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.remove(WAY_SIGN.get());
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            }
        }
    }

    private static void setupStructures() {
        StructureRegistry.setupMapSpacingAndLand((Structure)WAY_SIGN.get(), new StructureSeparationSettings(((Integer)ServerConfigs.spawn.ROAD_SIGN_DISTANCE_AVR.get()).intValue(), ((Integer)ServerConfigs.spawn.ROAD_SIGN_DISTANCE_MIN.get()).intValue(), 431041527), true);
    }

    private static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        try {
            Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
            ((Structure)Structure.field_236365_a_.get((Object)structure.getRegistryName().toString())).getRegistryName();
        }
        catch (Exception e) {
            Supplementaries.LOGGER.throwing((Throwable)new Exception("failed to register way sign structure: " + e + ". this is a bug"));
        }
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_;
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

