/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.client.gui.IScreenProvider;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientBoundOpenScreenPacket
implements NetworkHandler.Message {
    private final BlockPos pos;

    public ClientBoundOpenScreenPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
    }

    public ClientBoundOpenScreenPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void buffer(ClientBoundOpenScreenPacket message, PacketBuffer buffer) {
        buffer.func_179255_a(message.pos);
    }

    public static void handler(ClientBoundOpenScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (!context.getDirection().getReceptionSide().isServer()) {
                ClientBoundOpenScreenPacket.tryOpenScreen(message.pos);
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void tryOpenScreen(BlockPos pos) {
        TileEntity te;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && (te = level.func_175625_s(pos)) instanceof IScreenProvider) {
            ((IScreenProvider)te).openScreen((World)level, pos, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        }
    }
}

