/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.datagen;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class RecipeCondition
implements ICondition {
    public static final ResourceLocation MY_FLAG = new ResourceLocation("supplementaries", "flag");
    private final ResourceLocation res;
    private final String flag;

    public RecipeCondition(String flag, ResourceLocation loc) {
        this.flag = flag;
        this.res = loc;
    }

    public ResourceLocation getID() {
        return this.res;
    }

    public boolean test() {
        return RegistryConfigs.reg.isEnabled(this.flag);
    }

    public static class Serializer
    implements IConditionSerializer<RecipeCondition> {
        private final ResourceLocation location;

        public Serializer(ResourceLocation location) {
            this.location = location;
        }

        public void write(JsonObject json, RecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public RecipeCondition read(JsonObject json) {
            return new RecipeCondition(json.getAsJsonPrimitive("flag").getAsString(), this.location);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

